/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.operation.factory;

import org.eclipse.atf.templates.operation.ConditionalOperation;
import org.eclipse.atf.templates.operation.IOperation;
import org.eclipse.core.runtime.IConfigurationElement;


public class ConditionalOperationFactory implements IOperationFactory {

	protected static final String ATTR_CONDITION = "condition";
	
	protected static final String TAG_OPERATION = "operation";
	
	public IOperation createOperation(IConfigurationElement confElement) {
		ConditionalOperation operation = new ConditionalOperation();
		
		operation.setCondition( confElement.getAttribute(ATTR_CONDITION) );
		
		//add wrapped operations inside the conditional
		OperationFactoryRegistry opsFactoryRegistry = OperationFactoryRegistry.getInstance();
		IConfigurationElement [] operationElementArray = confElement.getChildren( TAG_OPERATION );
		
		for (int i = 0; i < operationElementArray.length; i++) {
			//search the OperationFactoryRegistry for the Factory for this operation type
			IOperationFactory opsFactory = opsFactoryRegistry.getOperationFactory( operationElementArray[i] );
			
			//factory could be null, so need to check
			if( opsFactory != null ){
				IOperation wrappedOperation = opsFactory.createOperation( operationElementArray[i] );
				operation.addOperation( wrappedOperation );				
			}
			
		}
		return operation;
	}

	
}
