/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.operation.factory;

import org.eclipse.atf.templates.FileTemplate;
import org.eclipse.atf.templates.Template;
import org.eclipse.atf.templates.TemplateFactory;
import org.eclipse.atf.templates.operation.CreateFileOperation;
import org.eclipse.atf.templates.operation.IOperation;
import org.eclipse.core.runtime.IConfigurationElement;


public class CreateFileOperationFactory implements IOperationFactory {

	protected static final String ATTR_NAME = "name";
	protected static final String ATTR_PROJECT = "project";
	protected static final String ATTR_LOCATION = "location";
	
	protected static final String TAG_TEMPLATE = "template";
	
	
	public IOperation createOperation(IConfigurationElement confElement) {
		CreateFileOperation operation = new CreateFileOperation();
		
		operation.setFilename( confElement.getAttribute(ATTR_NAME) );
		
		operation.setProject( confElement.getAttribute(ATTR_PROJECT) );
		
		operation.setLocation( confElement.getAttribute(ATTR_LOCATION) );
		
		//Template for file
		IConfigurationElement [] templateElement = confElement.getChildren( TAG_TEMPLATE );
		
		if( templateElement.length > 0 ){
			Template template = TemplateFactory.getInstance().createTemplate( templateElement[0] );
			operation.setFileTemplate( (FileTemplate)template );
		}
		
		return operation;
	}

}
