/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.operation.factory;

import org.eclipse.atf.templates.operation.IOperation;
import org.eclipse.atf.templates.operation.InstallRuntimeOperation;
import org.eclipse.core.runtime.IConfigurationElement;


public class InstallRuntimeOperationFactory implements IOperationFactory {

	protected static final String ATTR_PROJECT = "project";
	protected static final String ATTR_RUNTIME = "runtime";	
	
	public IOperation createOperation(IConfigurationElement confElement) {
		InstallRuntimeOperation operation = new InstallRuntimeOperation();
		
		operation.setProject( confElement.getAttribute(ATTR_PROJECT) );
		
		operation.setRuntime( confElement.getAttribute(ATTR_RUNTIME) );
		
		return operation;
	}

}
