/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.util;

import java.io.ByteArrayInputStream;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.jet.JETException;


public class JETExecutionHelper {
	protected static JETExecutionHelper instance = new JETExecutionHelper();

	public static JETExecutionHelper getInstance() {
		return instance;
	}

	protected JETExecutionHelper() {
		
	}
	
	/*
	 * This method will process tje JET string passed as an argument. As part
	 * of processing this method will:
	 * 
	 *  1. Generate a Generator JAVA class based on the template
	 *  2. Compile the Generator class
	 *  3. Execute the generate method in the Generated class to produce the
	 *     resulting string.
	 */
	public String generate( String jetTemplate ) throws JETException{
		
		String classDirective = "<%@ jet package=\"translated\" class=\"Foo\" %>\n";
		
		JETEmitter emitter = new JETEmitter( "foo", new ByteArrayInputStream( (classDirective + jetTemplate).getBytes()) );
		
		String genCode = emitter.generate( new NullProgressMonitor(), new Object[]{new Object()} );
		
		System.out.println( "GENCODE: " + genCode );
				
		return genCode;
		
	}
}
