/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.util;

import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.IVariableRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.text.edits.MalformedTreeException;


public class VariableSubtitutionHelper {
	
	protected static VariableSubtitutionHelper instance = new VariableSubtitutionHelper();
	
	public static VariableSubtitutionHelper getInstance() {
		return instance;
	}
	
	private TemplateTranslator translator = new TemplateTranslator();
	private TemplateContextType templateContextType = new TemplateContextType("internal");
	
	protected VariableSubtitutionHelper() {
	}
	
	public String substitute( String varTemplate, IVariableRegistry varRegistry ) throws TemplateException, MalformedTreeException, BadLocationException{
		
		String pattern = varTemplate;
		
		System.out.println( "READ IN: " + pattern );
		
		//create a TemplateBuffer from the input pattern
		TemplateBuffer templateBuffer = translator.translate( pattern );
		
		//if there are no variables return pattern
		if( templateBuffer.getVariables().length == 0 )
			return pattern;		
		
		templateContextType.resolve( templateBuffer, new IVariableTemplateContext(varRegistry));
		
		System.out.println( "RESOLVE: " + templateBuffer.getString() );
		
		return templateBuffer.getString();
	}
}

/*
 * This subclass of TemplateContext looks for the the substitution value of the
 * variable in the IVariableRegistry.
 */
class IVariableTemplateContext extends TemplateContext {
	
	private IVariableRegistry varReg = null;
	
	public IVariableTemplateContext( IVariableRegistry varReg ){
		super( null );
		this.varReg = varReg;
	}
	
	public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
		return null;
	}

	public boolean canEvaluate(Template template) {
		return false;
	}

	public String getVariable(String name) {
		
		//get the var from the Registry and resolve it
		IVariable var = varReg.lookupVariable(name);
		
		if( var != null )
			return var.resolve();
		
		else
			return null;
	}

	public void setVariable(String name, String value) {};
	
	public boolean isReadOnly() {
		return true;
	}
	

};