/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;

public class BooleanVariable extends VariableBase {

	public static final String TYPE = "Boolean";
	
	protected Boolean overrideValue;
	
	public boolean getBooleanValue(){
		
		//check if the value was set by the user
		if( overrideValue != null )
			return overrideValue.booleanValue();
		
		//check if value was set as an attribute
		else if( getValue() != null )
			return Boolean.valueOf(getValue()).booleanValue();
		
		else
			return false;
	}
	
	public void setBooleanValue( boolean value ){
		if( !Boolean.valueOf(value).equals(this.overrideValue) ){
			this.overrideValue = Boolean.valueOf(value);
			notifyChange();
		}
	}
	
	public String getType() {
		return TYPE;
	}

	public String resolve() {
		return String.valueOf( getBooleanValue() );
	}

	public void reset() {
		overrideValue = null;
	}

	public boolean isValidValue(){
		return true;
	}
}
