/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;

import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;

public class CssImportVariable extends VariableBase implements VariableListener {

	public static final String TYPE = "CssImports";
	
	protected FileInfo[] files;
	protected String projectValue;
	protected String folderValue;
	protected IVariable projectVariable;
	protected IVariable folderVariable;
	
	public CssImportVariable() {
		super();
	}
	
	//The value set through the XML could be a combination of other StringVariables
	public FileInfo[] getImportValue(){
		
		if( projectVariable == null || folderVariable == null ){
			interpretValue();
		}
		
		return files;
		
	}
	
	private void interpretValue() {
		
		//see if it contains dependencies
		try{
			TemplateTranslator projectTranslator = new TemplateTranslator();
			TemplateBuffer templateBuffer = projectTranslator.translate( getProjectValue() );
			setProjectDependency( templateBuffer );
						
			TemplateTranslator folderTranslator = new TemplateTranslator();
			templateBuffer = folderTranslator.translate( getFolderValue() );
			setFolderDependency( templateBuffer );
			
		}
		catch( Exception e ){
			e.printStackTrace();
		}
	}
	
	private void setProjectDependency(TemplateBuffer templateBuffer) {
		
		TemplateVariable[] variables = templateBuffer.getVariables();
		
		if( variables.length == 0 )
			return;
		
		//fast way to sort using Bucket (should be more memory efficient)
		//variables could be used multiple times so they may appear multiple times in the array
		TemplateVariable [] sortedVariables = new TemplateVariable[ templateBuffer.getString().length() ];
		for (int i = 0; i < variables.length; i++) {
			int[] offsets = variables[i].getOffsets();
			for (int j = 0; j < offsets.length; j++) {
				sortedVariables[offsets[j]] = variables[i]; //insert in bucket using offset
			}
		}
		
		for( int i=0; i<sortedVariables.length; i++ ){
			
			//lookup the IVariable with the name
			IVariable variable = registry.lookupVariable(sortedVariables[i].getName());
				
			//check that the variable exists and that it is of the String type
			if( variable!= null && variable instanceof StringVariable ){
				
				//add as listener in case of changes
				variable.addListener( this );
			} else if(variable != null && variable instanceof ProjectVariable) {
				variable.addListener( this );
			}
			i+=(sortedVariables[i].getLength()-1);
		}
	}
	
	private void setFolderDependency(TemplateBuffer templateBuffer) {
		
		
	}
	
	public boolean isValidValue() {
		return true;
	}

	public String getType() {
		return CssImportVariable.TYPE;
	}

	public String resolve() {
		// TODO Auto-generated method stub
		return null;
	}

	public void reset() { }
	
	public void setProjectValue(String value) {
		this.projectValue = value;
	}
	
	public String getProjectValue() {
		return projectValue;
	}
	
	public void setFolderValue(String value) {
		this.folderValue = value;
	}
	
	public String getFolderValue() {
		return folderValue;
	}

	public void variableChanged(IVariable source) {
		// TODO Auto-generated method stub
		
	}

}
