/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;



public interface IVariable {

	String getName();
	String getDisplayName();
	String getType();
	
	//resolve the IVariable into a String used in templates
	String resolve();
	
	//validation information
	boolean isRequired();
	boolean isValidValue();
	
	void reset();	
	
	void setVariableRegistry( IVariableRegistry registry );
	
	void addListener( VariableListener listener );
	void removeListener( VariableListener listener );
}
