/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;

import org.eclipse.atf.templates.util.VariableSubtitutionHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This IVariable computes the relative path to a folder depending on the currently
 * from folder.
 * 
 * Assume that all paths are relatives to the Project
 * to and from must be paths to folders
 */
public class RelativePathVariable extends VariableBase {

	public static final String TYPE = "RelativePath";
	
	//override if set through the set call
	protected String valueOverride;
	
	protected String to = ""; //could contain variables
	protected String from = ""; //set always before using
	

	public String getFrom() {
		return from;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public String getTo() {
		return to;
	}
	
	public void setTo(String to) {
		this.to = to;
	}

	public String getType() {
		return RelativePathVariable.TYPE;
	}

	public String resolve() {
		
		try{
		
			VariableSubtitutionHelper substitutionHelper = VariableSubtitutionHelper.getInstance();
			IPath toPath = new Path(substitutionHelper.substitute(getTo(), registry) );
			IPath fromPath = new Path(substitutionHelper.substitute(getFrom(), registry) );
					
			//These are number of ../ that need to inserted at the top of the path
			int matchingSegments = toPath.matchingFirstSegments( fromPath );
			int fromSegments = fromPath.segmentCount();
			
			StringBuffer pathBuffer = new StringBuffer();
			for( int i=0; i< fromSegments-matchingSegments; i++ ){
				pathBuffer.append("../");
			}
			
			pathBuffer.append( toPath.removeFirstSegments(matchingSegments).toString() );
			
			return pathBuffer.toString();
		}
		catch( Exception e ){
			e.printStackTrace();
			return "<!ERROR RESOLVING>";
		}
	}

	public boolean isValidValue() {
		return true;
	}

	public void reset() {}

	public static void main( String [] args ){
		
		RelativePathVariable var = new RelativePathVariable();
		var.setTo( "WebContent/zimbraAJAX" );
		var.setFrom( "helloWorld" );
		
		System.out.println( var.resolve() );
		
	}
}
