/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;

import java.util.StringTokenizer;

public class StringOptionsVariable extends StringVariable {
	
	public static final String TYPE = "StringOptions";
	protected static final String DELIMITER = "|";
	
	protected String [] options;
	
	public String getType() {
		return TYPE;
	}	
	
	public String[] getOptions() {
		return options;
	}


	public void setOptions(String[] options) {
		this.options = options;
	}

	/*
	 * This method converts the '|' separated string into an array of String options
	 */
	public static String [] parseOptionString( String optionString ){
		StringTokenizer tokenizer = new StringTokenizer( optionString, DELIMITER );
		
		String [] optionsResult = new String[tokenizer.countTokens()];
		
		for( int i=0; tokenizer.hasMoreTokens(); i++ )
			optionsResult[i] = tokenizer.nextToken();
		
		return optionsResult;
	}
}
