/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;

import org.eclipse.atf.templates.variable.value.IValue;
import org.eclipse.atf.templates.variable.value.LiteralValue;
import org.eclipse.atf.templates.variable.value.ValueParser;



public class StringVariable extends VariableBase implements VariableListener {
	
	public static final String TYPE = "String";
	
	//override if set through the setStringValue() call
	protected String valueOverride;
	
	//these placeholders allows the value to be composed of other Variables
	protected IValue internalValue;
	
	public StringVariable(){}

	//this would be the interface to the UI
	public void setStringValue( String value ){
		this.valueOverride = value;
		notifyChange();
	}
	
	//The value set through the XML could be a combination of other StringVariables
	public String getStringValue(){
		
		//if the value is changed through the setStringValue() that should be it
		if( valueOverride != null )
			return valueOverride;
		
		return getInternalValue().getValue();
		
	}
	
	protected IValue getInternalValue(){
		if( internalValue == null )
			internalValue = interpreteValueAttribute();
		
		return internalValue;
	}

	public String getType() {
		return StringVariable.TYPE;
	}

	public String resolve() {
		return getStringValue();
	}
	
	public void reset(){
		valueOverride = null;
		internalValue = null; //force a re-parse
	}
	
	/*
	 * StringVariable does not contain a ValidValue if the getStringValue is
	 * null or "". This might be ignored by users of the Variable but important
	 * if the Variable is set as required.
	 */
	public boolean isValidValue(){
		String varValue = getStringValue();
		if(varValue == null || varValue.equals("")) {
			return false;
		}
		else
			return true;
	}
	
	private IValue interpreteValueAttribute(){
		//a null value string should fallback to defaultValue
		if( getValue() == null ){
			return new LiteralValue("");
		}
		else{
			//parse the value attribute
			IValue value = ValueParser.getInstance().parse( getValue(), registry );
			
			//set as listener to Variables in the IValue
			if( value.containsVariable() )
				value.setListener( this );
			
			return value;
		}		
	}
	
	public void variableChanged(IVariable source) {
		//protect agains circular dependency
		if( this != source )
			notifyChange(source);
	}
}
