/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable;

import java.util.ArrayList;
import java.util.Iterator;



abstract public class VariableBase implements IVariable{

	//common values gathered from attributes in the XML
	protected String name;
	protected String displayName;
	protected boolean required = false;
	
	protected String _value;	//could be templates
	
	//to have access to other Variables
	protected IVariableRegistry registry;
	
	//listeners
	protected ArrayList listeners = new ArrayList();
	
	final public void setName(String name) {
		this.name = name;
	}

	final public String getName() {
		return name;
	}

	final public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	final public String getDisplayName() {
		return displayName;
	}
	
	/*
	 * The string value of this member is for internal use only. Subclasses should
	 * expose the represented Value with their own members and APIs.
	 */
	final protected String getValue(){
		return _value;
	}
	
	/*
	 * set the _value member and reset the Variable if it is different
	 */
	final public void setValue( String value ){
		if( this._value != null ){
			if( !this._value.equals(value) ){
				this._value = value;
				this.reset();
			}
		}
		else if( value != null ){
			//_value is null here so just set
			this._value = value;
			reset();
		}
		
	}
	
	final public void setRequired( boolean required ){
		this.required = required;
	}
	
	final public boolean isRequired() {
		return required;
	}

	abstract public boolean isValidValue();
	
	public void setVariableRegistry( IVariableRegistry registry ){
		this.registry = registry;
	}

	public void addListener(VariableListener listener) {
		listeners.add( listener );
	}

	public void removeListener(VariableListener listener) {
		listeners.remove( listener );
	}
	
	public void notifyChange(){
		notifyChange( this );
	}
	
	public void notifyChange( IVariable source ){
		for (Iterator iter = listeners.iterator(); iter.hasNext();) {
			VariableListener listener = (VariableListener) iter.next();
			listener.variableChanged( source );
		}
	}
	
}
