/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.factory;

import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.ProjectVariable;
import org.eclipse.atf.templates.variable.VariableBase;
import org.eclipse.atf.templates.variable.util.IProjectFilter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;


public class ProjectVariableFactory extends VariableFactoryBase {

	protected static final String ATTR_DEFAULTSELECTED = "defaultSelected";
	
	protected static final String TAG_PROJECTFILTER = "projectFilter";
	protected static final String ATTR_CLASS = "class";
	
	protected VariableBase instantiate() {
		return new ProjectVariable();
	}
	
	public IVariable createVariable(IConfigurationElement confElement) {
		
		ProjectVariable variable = (ProjectVariable)super.createVariable(confElement);
		
		variable.setDefaultSelected( getConfigurationElementAttribute(confElement,ATTR_DEFAULTSELECTED) );
		
		//filters
		try{
			IConfigurationElement [] filterElementArray = confElement.getChildren(TAG_PROJECTFILTER);
			
			for (int i = 0; i < filterElementArray.length; i++) {
				IProjectFilter filter = (IProjectFilter)filterElementArray[i].createExecutableExtension( ATTR_CLASS );
				variable.addProjectFilter( filter );
			}
		}
		catch( CoreException ce ){
			//skip
			ce.printStackTrace();
		}
		catch( ClassCastException cce ){
			//skip
			cce.printStackTrace();
		}
		
		
		return variable;
	}

}
