/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.factory;

import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.RelativePathVariable;
import org.eclipse.atf.templates.variable.VariableBase;
import org.eclipse.core.runtime.IConfigurationElement;


public class RelativePathVariableFactory extends VariableFactoryBase {

	protected static final String ATTR_TO = "to";
	protected static final String ATTR_FROM = "from";
	
	protected VariableBase instantiate() {
		return new RelativePathVariable();
	}

	public IVariable createVariable(IConfigurationElement confElement) {
		
		RelativePathVariable variable = (RelativePathVariable)super.createVariable( confElement );
		
		variable.setTo( getConfigurationElementAttribute(confElement,ATTR_TO) );
		variable.setFrom( getConfigurationElementAttribute(confElement,ATTR_FROM) );
		
		return variable;
	}
}
