/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.factory;

import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.StringOptionsVariable;
import org.eclipse.atf.templates.variable.VariableBase;
import org.eclipse.core.runtime.IConfigurationElement;


public class StringOptionsVariableFactory extends VariableFactoryBase {

	protected static final String ATTR_OPTIONS = "options";
	
	protected VariableBase instantiate() {
		return new StringOptionsVariable();
	}
	
	public IVariable createVariable(IConfigurationElement confElement) {
		StringOptionsVariable variable = (StringOptionsVariable)super.createVariable(confElement);
		
		String [] options = StringOptionsVariable
			.parseOptionString( getConfigurationElementAttribute(confElement, ATTR_OPTIONS));
		
		variable.setOptions( options );
		
		return variable;
	}

}
