/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.factory;

import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.VariableBase;
import org.eclipse.core.runtime.IConfigurationElement;


abstract public class VariableFactoryBase implements IVariableFactory {
	
	abstract protected VariableBase instantiate();
	
	public IVariable createVariable(IConfigurationElement confElement) {
		
		VariableBase variable = instantiate(); 
		
		variable.setName( getName(confElement) );
		variable.setDisplayName( getDisplayName(confElement) );
		
		//temporary support for defaultValue attribute
		String value = getValue(confElement);
		if( value != null )
			variable.setValue( value );
		else{
			String defaultValue = getDefaultValue(confElement);
			//set even if its null (should take care of null internally)
			variable.setValue( defaultValue );
		}
		variable.setRequired( getRequired(confElement) );
		
		return variable;
	}
	
	protected String getType( IConfigurationElement confElement ){
		return confElement.getAttribute( ATTR_TYPE );
	}

	protected String getName( IConfigurationElement confElement ){
		return confElement.getAttribute( ATTR_NAME );
	}
	
	protected String getDisplayName( IConfigurationElement confElement ){
		return confElement.getAttribute( ATTR_DISPLAYNAME );
	}
	
	protected String getValue( IConfigurationElement confElement ){
		return confElement.getAttribute( ATTR_VALUE );
	}
	
	/**
	 * @deprecated
	 */
	protected String getDefaultValue( IConfigurationElement confElement ){
		return confElement.getAttribute( ATTR_DEFAULTVALUE );
	}
	
	protected boolean getRequired( IConfigurationElement confElement ){
		String requiredStr = confElement.getAttribute( ATTR_REQUIRED );
		return Boolean.valueOf(requiredStr).booleanValue();
	}
	
	protected String getConfigurationElementAttribute( IConfigurationElement confElement, String attrName ){
		return confElement.getAttribute( attrName );
	}
}
