/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.factory;

import java.util.HashMap;

import org.eclipse.atf.templates.TemplatesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;


public class VariableFactoryRegistry {

	protected static final String PLUGIN_POINT = "variableFactory";
	protected static final String TAG_FACTORY = "factory";
	protected static final String ATTR_TYPE = "type";
	protected static final String ATTR_CLASS = "class";
	
	protected static VariableFactoryRegistry instance = new VariableFactoryRegistry();

	public static VariableFactoryRegistry getInstance() {
		return instance;
	}

	//Map of variable type to Factory
	protected HashMap factories = new HashMap();
	
	protected VariableFactoryRegistry() {
		init();
	}
	
	/**
	 * Reads the type value of the variable IConfigurationElement and returns for
	 * a factory for it. Returns null if no factory is found;
	 * 
	 * @param confElement IConfigurationElement for a variable
	 * @return IVariableFactory instance or null
	 */
	public IVariableFactory getVariableFactory( IConfigurationElement confElement ){
		
		String type = confElement.getAttribute(IVariableFactory.ATTR_TYPE);
		
		return (IVariableFactory)factories.get(type);
	}
	
	/**
	 * Read the extension point "variableFactory" and populate a map of variable
	 * type to Factory class
	 */
	protected void init(){
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(TemplatesPlugin.ID, 
				PLUGIN_POINT);
		
		if (point == null)
			return;
		IExtension[] extensions = point.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			
			for (int j = 0; j < elements.length; j++) {
				//go through all the factory declarations
				if (elements[j].getName().equals(TAG_FACTORY)) {
					
					String type = elements[j].getAttribute( ATTR_TYPE );
					
					try {
						Object factory = elements[j].createExecutableExtension( ATTR_CLASS );
						
						if( !(factory instanceof IVariableFactory) )
							continue; //ignore entries that are not implementations of VariableFactory
						
						//TODO: Decide what to do when factories are set for different types
						factories.put( type, factory );
						
					} catch (CoreException e) {
						e.printStackTrace();
					}
					
					
				}
			}
		}
		
	}
}
