/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.value;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.atf.templates.variable.VariableListener;


/*
 * This class represents a value that is a combination of IValues
 */
public class CompositeValue implements IValue {

	protected ArrayList valueList = new ArrayList();
	
	public String getValue() {
		//concatenate all the Strings
		StringBuffer buffer = new StringBuffer();
		for (Iterator iter = valueList.iterator(); iter.hasNext();) {
			IValue value = (IValue) iter.next();
			buffer.append( value.getValue() );
		}
		
		return buffer.toString();
	}
	
	public void addIValue( IValue value ){
		valueList.add( value );
	}

	public boolean containsVariable() {
		return true; //there is always at least on IVariable
	}

	public void setListener(VariableListener listener) {
		for (Iterator iter = valueList.iterator(); iter.hasNext();) {
			IValue value = (IValue) iter.next();
			if( value.containsVariable() )
				value.setListener( listener );
		}
	}

	public void unsetListener(VariableListener listener) {
		for (Iterator iter = valueList.iterator(); iter.hasNext();) {
			IValue value = (IValue) iter.next();
			if( value.containsVariable() )
				value.unsetListener( listener );
		}		
	}
	
	

}
