/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.variable.value;

import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.VariableListener;

/*
 * This class represent a value that comes from resolving an IVariable
 */
public class VariableValue implements IValue {

	protected IVariable variable = null;
	
	public VariableValue( IVariable variable ){
		this.variable = variable;
	}
	
	public String getValue() {
		return variable.resolve();
	}

	public boolean containsVariable() {
		return true;
	}

	public void setListener(VariableListener listener) {
		variable.addListener( listener );
	}

	public void unsetListener(VariableListener listener) {
		variable.removeListener( listener );
	}
}
