/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.templates;

import java.io.IOException;

import org.eclipse.atf.ui.UIPlugin;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;


public class TemplateRegistry {

	private TemplateStore fTemplateStore;
	private ContributionContextTypeRegistry fContextTypeRegistry;
	private static TemplateRegistry instance = null;
	/*
	* This constant is also defined in org.eclipse.jst.jsp.ui.internal.preferences.JSPUIPreferenceNames.
	* The code is not accessing it directly so that there isn't a dependency on org.eclipse.jst.  
	*/
	private static String TEMPLATES_KEY= "org.eclipse.wst.sse.ui.custom_templates"; //$NON-NLS-1$
	
	public static TemplateRegistry getInstance() {
		if(instance == null) {
			instance = new TemplateRegistry();
		}
		return instance;
			
	}
	
	private TemplateRegistry() {
		super();
	}
	
	public TemplateStore getTemplateStore() {
		if (fTemplateStore == null) {
			fTemplateStore= new ContributionTemplateStore(getTemplateContextRegistry(), UIPlugin.getDefault().getPreferenceStore(), TEMPLATES_KEY);

			try {
				fTemplateStore.load();
			} catch (IOException e) {
				UIPlugin.log(e);
			}
		}		
		return fTemplateStore;
	}
	
	public ContributionContextTypeRegistry getTemplateContextRegistry() {
		if (fContextTypeRegistry == null) {
			ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
			fContextTypeRegistry= registry;
		}

		return fContextTypeRegistry;
	}
	
	public void addTemplateContextType(String contextType) {
		ContributionContextTypeRegistry registry = getTemplateContextRegistry();
		if(registry.getContextType(contextType) == null) {
			registry.addContextType(contextType);
			fTemplateStore = new ContributionTemplateStore(registry, UIPlugin.getDefault().getPreferenceStore(), TEMPLATES_KEY);
			try {
				fTemplateStore.load();
			} catch (IOException e) {
				UIPlugin.log(e);
			}
		}
	}
}
