/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.wizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FileIncludeContentProvider implements
		IStructuredContentProvider {

	private IPath[] paths = null;
	
	public Object[] getElements(Object inputElement) {
		
		FileIncludeInfo[] infos = new FileIncludeInfo[paths.length];
		for(int i=0; i<paths.length; i++) {
			infos[i] = new FileIncludeInfo(paths[i].lastSegment(), paths[i].toString());
		}
		return infos;
	}

	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		paths = (IPath[])newInput;
		
	}

}
