/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.ui.debug;

import java.net.URL;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserProcess;
import org.eclipse.atf.mozilla.ide.ui.browser.util.MozBrowserUtil;
import org.eclipse.atf.mozilla.ide.ui.perspective.MozillaPerspective;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.WebLaunchableClient;

public class MozillaWebLaunchableClient extends WebLaunchableClient {

	/*
	 * @see WebLaunchableClient#launch(IServer, Object, String, ILaunch)
	 */
	public IStatus launch(IServer server, Object launchable, String launchMode, ILaunch launch) {
		HttpLaunchable http = (HttpLaunchable) launchable;
		try {
			if(launchMode.equals(ILaunchManager.RUN_MODE)) {
				final ILaunch launchObj = launch;
				final URL url = http.getURL();
				Display.getDefault().syncExec(new Runnable() {

					public void run() {
						try {
							Browser browser = MozBrowserUtil.openMozillaBrowser( url.toString() );
							//Process adds itself to the launch
							new MozBrowserProcess(browser, launchObj);
						} catch (CoreException e) {
							e.printStackTrace();
							return;
						}
					}
						
				});
				
				final IWorkbenchWindow window = getActiveWorkbenchWindow();
				//Switch to Mozilla perspective
				if(window != null) {
					Display.getDefault().syncExec(new Runnable() {

						public void run() {
							try {
								MozIDEUIPlugin.getDefault().getWorkbench().showPerspective( MozillaPerspective.ID, window );
							} catch(WorkbenchException e) {
								e.printStackTrace();
							}
						}
							
					});
					
				}	
			}
		} catch (Exception e) {
			Trace.trace(Trace.SEVERE, "Error opening browser", e);
		}
		return null;
	}
	
	private IWorkbenchWindow getActiveWorkbenchWindow() {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if(window == null) {
			IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
			if(windows.length > 0)
				window = windows[0];
		}
		return window;
	}
}
