/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.preferences;

import java.io.File;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.preferences.IPreferenceConstants;

public class MozillaPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage, IPreferenceConstants, Listener, ModifyListener {

	protected IPreferenceStore store;
	protected Label browserLabel;
	protected Text browserText;
	protected Button browserButton;
	protected IWorkbench workbench;
	
	public MozillaPreferencePage() {
		super();
		store = doGetPreferenceStore();
	}
	
	public MozillaPreferencePage(String title) {
		super(title);
		store = doGetPreferenceStore();
	}
	
	public MozillaPreferencePage(String title, ImageDescriptor descriptor) {
		super(title, descriptor);
		store = doGetPreferenceStore();
	}
	
	protected Control createContents(Composite parent) {
		Composite composite1 = new Composite(parent, SWT.NULL);
		composite1.setFont(parent.getFont());
		composite1.setLayout(new GridLayout());
		composite1.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Group debugGroup = new Group(composite1, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		debugGroup.setLayout(layout);
		debugGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		debugGroup.setFont(parent.getFont());
		debugGroup.setText("Mozilla Options"); 
		
		//Web browser
		browserLabel = new Label(debugGroup, SWT.NONE);
		browserLabel.setText("Mozilla location");
		browserLabel.setToolTipText("The location of the Mozilla executable on the local system.");
		
		browserText = new Text(debugGroup, SWT.BORDER);
		browserText.setToolTipText("The location of the Mozilla executable on the local system.");
		browserText.addModifyListener(this);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL);
		browserText.setLayoutData(data);
		
		browserButton = new Button(debugGroup, SWT.PUSH);
		browserButton.setText("Browse...");
		browserButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		browserButton.addListener(SWT.Selection, this);
						
		
		initializeValues();
		
		return composite1;
	}
	
	protected IPreferenceStore doGetPreferenceStore() {
		return CorePlugin.getDefault().getPreferenceStore();
	}
	
	protected void initializeValues() {
		
		browserText.setText(store.getString(WEB_BROWSER_LOCATION));
		
	}
	
	protected void storeValues() {
		
		store.setValue(WEB_BROWSER_LOCATION, browserText.getText());
		CorePlugin.getDefault().savePluginPreferences();
			
	}
	
	protected void initializeDefaults() {
	
		browserText.setText(store.getDefaultString(WEB_BROWSER_LOCATION));
	}

	public void init(IWorkbench workbench) {
		this.workbench = workbench;

	}
	
	public boolean performOk() {
		storeValues();
		return super.performOk();
	}
	
	protected void performDefaults() {
		initializeDefaults();
	}

	public void handleEvent(Event event) {
		if(event.widget == browserButton) {
			//Open file browse dialog
			FileDialog d = new FileDialog(getShell());
			d.setFilterPath(browserText.getText());
			d.setText("Select Mozilla location:");
			String sel = d.open();
			if(sel !=null) {
				File file = new File(sel);
				if(file.exists()) {
					browserText.setText(file.getAbsolutePath());
					browserText.setToolTipText(file.getAbsolutePath());
				}
			}
		}
		
	}

	public void modifyText(ModifyEvent e) {
		if(e.widget == browserText) {
			browserText.setToolTipText(browserText.getText());
		}
				
		setValid(isValid());
		updateApplyButton();
		
	}
	
	public boolean isValid() {
				
		setErrorMessage(null);
		return true;
	}

}
