/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.ui.project;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.project.facet.SimpleWebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.web.ui.internal.WSTWebUIPlugin;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;
import org.eclipse.wst.web.ui.internal.wizards.SimpleWebProjectFirstPage;

/**
 * This class is similar to SimpleWebProjectWizard, but provides a simpler
 * wizard interface by hiding the facet related wizard pages.
 */
public class ATFProjectWizard extends NewProjectDataModelFacetWizard
{
	private static final String WINDOW_TITLE = "New AJAX Toolkit Project";
	private static final String FIRST_PAGE_TITLE = "AJAX Toolkit Project";
	private static final String FIRST_PAGE_DESCRIPTION =
		"Create a web project with AJAX Toolkit functionality.";

	public ATFProjectWizard( IDataModel model )
	{
		super( model );
		setWindowTitle( WINDOW_TITLE );
	}
	public ATFProjectWizard()
	{
		super();
		setWindowTitle( WINDOW_TITLE );
	}

	protected IDataModel createDataModel()
	{
		return DataModelFactory
			.createDataModel( new SimpleWebFacetProjectCreationDataModelProvider() );
	}

	protected IWizardPage createFirstPage()
	{
		SimpleWebProjectFirstPage page =
			new SimpleWebProjectFirstPage( model, "first.page" )
		{
			// We don't want to display "Target Runtime" and "Configurations"
			// groups, so we override them here.

			protected void createPresetPanel( Composite top )
			{
				// do nothing
			}

			protected void createServerTargetComposite( Composite parent )
			{
				// do nothing
			}
		};
		
		page.setTitle( FIRST_PAGE_TITLE );
		page.setDescription( FIRST_PAGE_DESCRIPTION );
		
		return page;
	}

	protected ImageDescriptor getDefaultPageImageDescriptor()
	{
		return WSTWebUIPlugin.getDefault().getImageDescriptor( "newwprj_wiz" );
	}

	protected IFacetedProjectTemplate getTemplate()
	{
		// Returns our template which automatically selects the ATF facet
		// (and the Static Web facet that it depends on).
		return ProjectFacetsManager.getTemplate( "template.atf" );
	}
	
	public IWizardPage getNextPage( IWizardPage page )
	{
		// In order to simplify wizard, skip over FacetsSelectionPage
		
		IWizardPage nextPage = super.getNextPage( page );

		if ( nextPage != null &&
				nextPage.getName().equals( "facets.selection.page" ))
		{
			nextPage = super.getNextPage( nextPage );
		}

		return nextPage;
	}
	
	public IWizardPage getPreviousPage( IWizardPage page )
	{
		// In order to simplify wizard, skip over FacetsSelectionPage
		
		IWizardPage previousPage = super.getPreviousPage( page );
		
		if ( previousPage != null &&
				previousPage.getName().equals( "facets.selection.page" ))
		{
			previousPage = super.getPreviousPage( previousPage );
		}
		
		return previousPage;
	}

}
