/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.ui.runtime;

import java.net.URL;
import java.util.ArrayList;

import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.ui.UIPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class InstalledToolkitsLabelProvider extends LabelProvider
		implements ITableLabelProvider, ITableColorProvider
{
	private Image toolkitImage;
	private Image invalidToolkitImage;

	private ArrayList errorToolkits;
	private ArrayList invalidToolkits;

	private Color colorRed;
	private Color colorGray;

	public InstalledToolkitsLabelProvider()
	{
		Bundle bundle = UIPlugin.getDefault().getBundle();
		URL url = FileLocator.find( bundle,
				new Path( "icons/full/ctool16/runtime.gif" ), null);
		ImageDescriptor id = ImageDescriptor.createFromURL( url );
		toolkitImage = id.createImage();

		url = FileLocator.find( bundle,
				new Path( "icons/full/ctool16/runtime_error.gif" ), null );
		id = ImageDescriptor.createFromURL( url );
		invalidToolkitImage = id.createImage();

		colorRed = Display.getCurrent().getSystemColor( SWT.COLOR_RED );
		colorGray = Display.getCurrent().getSystemColor( SWT.COLOR_GRAY );
	}
	
	public void dispose()
	{
		super.dispose();
		toolkitImage.dispose();
		invalidToolkitImage.dispose();
	}

	public Image getColumnImage( Object element, int columnIndex )
	{
		if ( columnIndex != 0 )	// NAME
			return null;

		if ( invalidToolkits != null && invalidToolkits.contains( element ) )
			return invalidToolkitImage;
		
		return toolkitImage;
	}

	public String getColumnText( Object element, int columnIndex )
	{
		IRuntimeInstance ri = (IRuntimeInstance) element;

		switch ( columnIndex )
		{
			case 0: // NAME
			{
				return ri.getName();
			}

			case 1: // KIND
			{
				return ri.getType().getName();
			}

			case 2: // VERSION
			{
				return ri.getVersion();
			}

			case 3: // LOCATION
			{
				return ri.getLocation();
			}

			default:
				break;
		}

		return null;
	}

	public void addListener( ILabelProviderListener listener )
	{
	}

	public void removeListener( ILabelProviderListener listener )
	{
	}

	public boolean isLabelProperty( Object element, String property )
	{
		if ( property.equals( "error-state" ))
			return true;
		
		return false;
	}

	public void setErrorToolkits( ArrayList toolkits )
	{
		errorToolkits = toolkits;
	}
	
	public Color getBackground( Object element, int columnIndex )
	{
		return null;
	}

	public Color getForeground( Object element, int columnIndex )
	{
		if ( errorToolkits != null && errorToolkits.contains( element ) )
			return colorRed;

		if ( invalidToolkits != null && invalidToolkits.contains( element ) )
			return colorGray;
		
		return null;
	}

	public void setInvalidToolkits( ArrayList invalidToolkits )
	{
		this.invalidToolkits = invalidToolkits;
	}

	public Image getInvalidToolkitImage()
	{
		return invalidToolkitImage;
	}
}
