/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.ui.runtime.standins;

import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.RuntimeInstance;

public class RuntimeInstanceStandin implements IRuntimeInstance {

	//this is the real instance in case it is being edited
	//it remains null if Adding a new instance
	protected RuntimeInstance realInstance = null;
	
	/* changed values */
	protected String location = null;
	protected String name = null;
	protected String version = null;
	protected RuntimeStandin type = null;
	
	protected boolean isNew = false;
	
	//used when Adding a new instance
	public RuntimeInstanceStandin(){
		realInstance = new RuntimeInstance();
		realInstance.setIsUser( true );
		isNew = true;
	}
	
	//used when Editing an existing instance
	public RuntimeInstanceStandin( RuntimeInstance realInstance, RuntimeStandin runtimeStandin ){
		this.realInstance = realInstance;
		this.type = runtimeStandin;
	}
	
	public RuntimeInstance getRealInstance(){
		return realInstance;
	}
	
	public String getLocation() {
		
		if( !isNew && location == null ){
			return realInstance.getLocation();
		}
		else{
			return location;
		}
		
	}

	public String getName() {
		if( !isNew && name == null ){
			return realInstance.getName();
		}
		else{
			return name;
		}
	}

	public IRuntime getType() {
		return type; //could be null
	}

	//Can only be set once
	public void setType(RuntimeStandin type) {
		if( this.type == null )
			this.type = type;
	}

	public String getVersion() {
		if( !isNew && version == null ){
			return realInstance.getVersion();
		}
		else{
			return version;
		}
	}

	//All added and editable instance are user defined
	public boolean isUser() {
		return realInstance.isUser();
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public boolean isNew(){
		return this.realInstance == null;
	}
	
	/**
	 * This method commits all the changed made in the Dialogs back to the model
	 */
	public void commitChanges(){
		//only commit if the real instance is user
		if( realInstance.isUser() ){
			if( name != null )
				realInstance.setName( name );
			
			if( version != null )
				realInstance.setVersion( version );
			
			if( location != null )
				realInstance.setLocation(location);
		}
	}

	public boolean equals( Object obj )
	{
		if ( obj instanceof RuntimeInstanceStandin )
			return super.equals( obj );
		
		return realInstance.equals( obj );
	}
}
