/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.util;

import java.util.ArrayList;

import org.eclipse.atf.project.FlexibleProjectUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CssUtils {

	/**
	 * Returns an array of IPath instances which are locations of previously generated image
	 * style sheets.
	 * @param createFolder
	 */
	public static IPath[] getPotentialCssImageImportPaths(IProject project) throws Exception {
		
		ArrayList results = new ArrayList();
		
		IContainer webContentRoot = FlexibleProjectUtils.getWebContentFolder(project);
		if(webContentRoot.exists()) {
			results = FlexibleProjectUtils.getFilePathsForType(webContentRoot, "css", results);
		}
				
		IPath[] paths = new IPath[results.size()];
		paths = (IPath[])results.toArray(paths);
				
		return paths;
	}
	
	/**
	 * Returns the JSP import syntax for importing the supplied css locations. Also will remove
	 * the WebContent directory from each location such that each import instance is valid.
	 * @param cssLocations
	 * @return
	 */
	public static String constructCssImportString(IProject project, String[] cssLocations) {
		
		if(cssLocations == null)
			return "";
		
		String importString = "";
		for(int i=0; i<cssLocations.length; i++) {
			IPath p = new Path(cssLocations[i]);
			p = p.makeAbsolute();
			String[] segs = p.segments();
			IPath newPath = new Path("");
			newPath = newPath.makeAbsolute();
			for(int j=0; j<segs.length; j++) {
				if(segs[j].equals("WebContent"))
					continue;
				newPath = newPath.append(segs[j]);
			}
			importString += "@import url(" + newPath.toString() + ");\n";
		}
		
		return importString;
	}
	
	
}
