/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

import org.eclipse.atf.util.ErrorStatusUtilities;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;




/**
 * @author Don Sedota
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ErrorStatusDisplayUtilities {

	public static void showErrorDialog(Exception e, String title, String message, Class clz, String pluginId) {
		
		Shell shell = null;
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if(window == null) {
			IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
			if(windows.length != 0) {
				window = windows[0];
			}
		}
		if(window != null)
			shell = window.getShell();
		if(shell != null) {
			final Exception fEx = e;
			final Class fClz = clz;
			final String fPluginId = pluginId;
			final String fMessage = message;
			final String fTitle = title;
			shell.getDisplay().asyncExec(new Runnable() {
				public void run() {
					MultiStatus multiStatus = ErrorStatusUtilities.createMultiStatusFromException(fEx, fClz, fPluginId, fMessage + "\n" + fEx.getMessage());
					ErrorDialog.openError(null, fTitle, fTitle, multiStatus);	
				}
			});
		}
		
	}
	
	public static void showErrorDialog( final String title, final String message, final IStatus status ) {
		
		Shell shell = null;
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if(window == null) {
			IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
			if(windows.length != 0) {
				window = windows[0];
			}
		}
		if(window != null)
			shell = window.getShell();
		if(shell != null) {
			
			shell.getDisplay().asyncExec(new Runnable() {
				public void run() {
					ErrorDialog.openError(null, title, message, status);	
				}
			});
		}
		
	}

}
