/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.util;

import java.util.ArrayList;

import org.eclipse.atf.project.FlexibleProjectUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JsUtils {

		
	/**
	 * Returns an array of IPath instances.
	 * @param createFolder
	 */
	public static IPath[] getPotentialJsIncludePaths(IProject project) throws Exception {
		
		ArrayList results = new ArrayList();
					
		IContainer webContentRoot = FlexibleProjectUtils.getWebContentFolder(project);
		if(webContentRoot.exists()) {
			results = FlexibleProjectUtils.getFilePathsForType(webContentRoot, "js", results);
		}
		
		IPath[] paths = new IPath[results.size()];
		paths = (IPath[])results.toArray(paths);
				
		return paths;
	}
	
	/**
	 * Returns the import syntax for importing the supplied css locations. Also will remove
	 * the WebContent directory from each location such that each import instance is valid.
	 * @param cssLocations
	 * @return
	 */
	public static String constructJsIncludeString(IProject project, String[] jsLocations) {
		
		if(jsLocations == null)
			return "";
		
		String importString = "";
		/*try {
			if(project.hasNature(J2EEProjectUtils.J2EE_NATURE_ID)) {
				for(int i=0; i<jsLocations.length; i++) {
					IPath p = new Path(jsLocations[i]);
					p = p.makeAbsolute();
					String[] segs = p.segments();
					IPath newPath = new Path("");
					newPath = newPath.makeAbsolute();
					for(int j=0; j<segs.length; j++) {
						if(segs[j].equals("WebContent"))
							continue;
						newPath = newPath.append(segs[j]);
					}
					importString += "<script type=\"text/javascript\" src=\"" + newPath.toString() + "\"></script>\n";
				}
			} else {
				IStaticWebNature sNature = StaticWebProjectUtils.getStaticWebNature(project);
				if(sNature != null) {
					IContainer rootPublishableFolder = sNature.getRootPublishableFolder();
					IPath projRelRootPublishablePath = rootPublishableFolder.getProjectRelativePath();
					for(int i=0; i<jsLocations.length; i++) {
						IPath p = new Path(jsLocations[i]).makeAbsolute();
						IPath newPath = new Path("");
						newPath = newPath.makeAbsolute();
						String[] segs = p.segments();
						for(int j=0; j<segs.length; j++) {
							if(projRelRootPublishablePath.isPrefixOf(p)) {
								int pubPathSegCount = projRelRootPublishablePath.segmentCount();
								p = p.removeFirstSegments(pubPathSegCount);
								if(pubPathSegCount > 1) 
									j += (pubPathSegCount - 1);
							} else {
								newPath = newPath.append(segs[j]);			
								p = p.removeFirstSegments(1).makeAbsolute();
							}
						}
						importString += "<script type=\"text/javascript\" src=\"" + newPath.toString() + "\"></script>\n";
					}
				}
			}
		} catch(CoreException e) {
			e.printStackTrace();
			return "";
		}*/
		
		for(int i=0; i<jsLocations.length; i++) {
			IPath p = new Path(jsLocations[i]);
			p = p.makeAbsolute();
			String[] segs = p.segments();
			IPath newPath = new Path("");
			newPath = newPath.makeAbsolute();
			for(int j=0; j<segs.length; j++) {
				if(segs[j].equals("WebContent"))
					continue;
				newPath = newPath.append(segs[j]);
			}
			importString += "<script type=\"text/javascript\" src=\"" + newPath.toString() + "\"></script>\n";
		}
		
		return importString;
	}
		
}
