/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.ui.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SelectionTester extends PropertyTester {

	public SelectionTester() {
		super();
	}
	
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		try {
			if(receiver instanceof IStructuredSelection) {
				IStructuredSelection selection = (IStructuredSelection)receiver;
				Object firstElement = selection.getFirstElement();
				if(firstElement instanceof IFile) {
					IFile file = (IFile)firstElement;
					if(file.getFileExtension().equals("jsp"))
						return true;
				}
			}
		} catch(Exception e) {
			return false;
		}
		return false;
		
	}
	
	

}
