/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui;

import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class URLStorageDocumentProvider
extends StorageDocumentProvider {
    private IWorkspace fWorkspace;
    private IResource fRoot;

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (this.fRoot == null) {
            this.fWorkspace = ResourcesPlugin.getWorkspace();
            this.fRoot = this.fWorkspace.getRoot();
        }
        IEditorInput storage = (IEditorInput)element;
        return new URLStorageAnnotationModel(storage.getName());
    }

    protected class URLStorageAnnotationModel
    extends ResourceMarkerAnnotationModel {
        private String fName;

        public URLStorageAnnotationModel(String name) {
            super(URLStorageDocumentProvider.this.fRoot);
            this.fName = name;
        }

        protected boolean isAcceptable(IMarker marker) {
            String id = null;
            try {
                id = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
            }
            catch (CoreException e) {
                MozillaDebugUIPlugin.log(e);
            }
            return marker != null && URLStorageDocumentProvider.this.fRoot.equals((Object)marker.getResource()) && this.fName.equals(id);
        }
    }
}

