/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.internal.adapter;

import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugScriptElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTopScriptElement;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.atf.mozilla.ide.debug.ui.util.FunctionNameLookupUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.model.elements.ElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;

public class JSDebugScriptElementLabelAdapter
extends ElementLabelProvider {
    protected ImageDescriptor topScriptElementImageDesc = MozillaDebugUIPlugin.getImageDescriptor("icons/topScriptElement.gif");
    protected ImageDescriptor scriptElementImageDesc = MozillaDebugUIPlugin.getImageDescriptor("icons/scriptElement.gif");

    protected ImageDescriptor[] getImageDescriptors(Object element, IPresentationContext context) throws CoreException {
        if (element instanceof JSDebugTopScriptElement) {
            return new ImageDescriptor[]{this.topScriptElementImageDesc};
        }
        if (element instanceof JSDebugScriptElement) {
            return new ImageDescriptor[]{this.scriptElementImageDesc};
        }
        return null;
    }

    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (element instanceof JSDebugTopScriptElement) {
            return this.topScriptElementImageDesc;
        }
        if (element instanceof JSDebugScriptElement) {
            return this.scriptElementImageDesc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (element instanceof JSDebugTopScriptElement) {
            JSDebugTopScriptElement cfr_ignored_0 = (JSDebugTopScriptElement)element;
            return ((JSDebugTopScriptElement)element).getName();
        }
        JSDebugScriptElement scriptElement = (JSDebugScriptElement)element;
        String _displayFunction = scriptElement.getName();
        if ("anonymous".equals(_displayFunction)) {
            try {
                String guess;
                JSDebugScriptElementLabelAdapter jSDebugScriptElementLabelAdapter = this;
                synchronized (jSDebugScriptElementLabelAdapter) {
                    guess = FunctionNameLookupUtil.getInstance().guessFunction(scriptElement);
                }
                if (guess != null) {
                    _displayFunction = "[" + guess + "]";
                    scriptElement.setName(_displayFunction);
                }
            }
            catch (Exception exception) {}
        } else if (_displayFunction == "__unnamed__") {
            StringBuffer buf = new StringBuffer();
            buf.append("<script (");
            buf.append(scriptElement.getLineStart());
            buf.append(":");
            buf.append(scriptElement.getLineStart() + scriptElement.getLineTotal());
            buf.append(")/>");
            scriptElement.setName(buf.toString());
        }
        return scriptElement.getName();
    }
}

