/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugScriptElement;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;

public class FunctionNameLookupUtil {
    private static FunctionNameLookupUtil instance = null;
    private InputStream cachedIS = null;
    private String cachedISLocation = "";
    private int linesRead = 0;
    private final Pattern _propertyPattern = Pattern.compile("(\\w+)\\s*[:=]\\s*$");

    public static FunctionNameLookupUtil getInstance() {
        if (instance == null) {
            instance = new FunctionNameLookupUtil();
        }
        return instance;
    }

    private FunctionNameLookupUtil() {
    }

    private InputStream getScriptContents(JSDebugScriptElement scriptElement) throws CoreException {
        String location = scriptElement.getLocation();
        try {
            if (location != null) {
                if (this.cachedISLocation.equals(location) && this.cachedIS != null) {
                    return this.cachedIS;
                }
                URL locationURL = new URL(location);
                String appBase = ((JSSourceLocator)scriptElement.getLaunch().getSourceLocator()).getAppBase();
                IProject project = ((JSSourceLocator)scriptElement.getLaunch().getSourceLocator()).getProject();
                this.cachedIS = SourceLocatorUtil.getInstance().getSourceContent(locationURL, appBase, project);
                this.cachedISLocation = location;
                this.linesRead = 0;
                if (this.cachedIS.markSupported()) {
                    this.cachedIS.mark(1024);
                }
                return this.cachedIS;
            }
        }
        catch (MalformedURLException mue) {
            Status status = new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, "Invalid URL supplied by Mozilla.  Unable to open source.", (Throwable)mue);
            DebugPlugin.log((IStatus)status);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, "Incorrect URL <" + location + ">", (Throwable)mue));
        }
        return null;
    }

    private void clearCache() {
        this.cachedIS = null;
        this.cachedISLocation = "";
        this.linesRead = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String guessFunction(JSDebugScriptElement scriptElement) {
        String guess = null;
        try {
            String match;
            CharSequence line;
            Vector<String> lines = new Vector<String>();
            long base = scriptElement.getLineStart();
            if (base < (long)this.linesRead) {
                this.clearCache();
            }
            InputStream stream = this.getScriptContents(scriptElement);
            stream.reset();
            int i = this.linesRead;
            while ((long)i < base) {
                int ch;
                if ((long)i == base - 1L && this.cachedIS.markSupported()) {
                    this.cachedIS.mark(1024);
                }
                line = new StringBuffer();
                do {
                    if ((ch = stream.read()) == -1) {
                        return null;
                    }
                    if (ch == 10) continue;
                    ((StringBuffer)line).append((char)ch);
                } while (ch != 10);
                lines.add(((StringBuffer)line).toString());
                ++i;
            }
            this.linesRead = (int)base - 1;
            line = (String)lines.lastElement();
            int offset = ((String)line).indexOf(match = "function");
            if (offset == -1) {
                return null;
            }
            StringBuffer region = new StringBuffer(((String)line).substring(0, offset));
            int linesJustReadCount = lines.size();
            int j = 2;
            while (j < 5 && linesJustReadCount - j > 0) {
                region.insert(0, (String)lines.elementAt(linesJustReadCount - j));
                ++j;
            }
            Matcher m = this._propertyPattern.matcher(region.toString());
            if (!m.find()) return guess;
            return m.group(1);
        }
        catch (CoreException ce) {
            MozillaDebugPlugin.log((Throwable)ce);
            return guess;
        }
        catch (IOException ioe) {
            MozillaDebugPlugin.log((Throwable)ioe);
        }
        return guess;
    }
}

