/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import java.util.HashMap;
import java.util.List;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.common.WebBrowserType;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.BrowserCreatedEvent;
import org.eclipse.atf.mozilla.ide.ui.browser.BrowserDisposedEvent;
import org.eclipse.atf.mozilla.ide.ui.browser.DOMEventsPublisher;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserEditorInput;
import org.eclipse.atf.mozilla.ide.ui.browser.PopupWindowBrowserListener;
import org.eclipse.atf.mozilla.ide.ui.browser.SelectionBox;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.IBrowserToolbar;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.NavigationBar;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.StatusBar;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.ToolbarExtensionManager;
import org.eclipse.atf.mozilla.ide.ui.browser.views.BrowserViewExtensionManager;
import org.eclipse.atf.mozilla.ide.ui.console.IJavaScriptConsole;
import org.eclipse.atf.mozilla.ide.ui.console.IJavaScriptConsoleViewAdapter;
import org.eclipse.atf.mozilla.ide.ui.console.JavaScriptConsoleListener;
import org.eclipse.atf.mozilla.ide.ui.console.JavaScriptConsolePage;
import org.eclipse.atf.mozilla.ide.ui.inspector.ATFInternalNodeFilter;
import org.eclipse.atf.mozilla.ide.ui.netmon.MozNetworkMonitorAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IPage;
import org.mozilla.interfaces.nsICacheService;
import org.mozilla.interfaces.nsIConsoleListener;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsIConsoleService;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMHTMLFrameElement;
import org.mozilla.interfaces.nsIDOMHTMLIFrameElement;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMutationEvent;
import org.mozilla.interfaces.nsIDOMNSHTMLElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class MozBrowserEditor
extends EditorPart
implements IWebBrowser,
ISelectionProvider,
ISelectionListener {
    public static final String ID = "org.eclipse.atf.mozilla.ide.ui.MozBrowserEditor";
    public static final WebBrowserType MOZILLA_BROWSER = new WebBrowserType("Mozilla", "*");
    public static final String DEFAULT_URL = "about:blank";
    protected Action backAction = null;
    protected Action forwardAction = null;
    protected Action refreshAction = null;
    protected Action stopAction = null;
    protected Action goAction = null;
    protected Action clearCacheAction = null;
    protected Action clickSelectAction = null;
    protected NavigationBar navBar = null;
    protected StatusBar statusBar = null;
    protected Browser browser = null;
    protected List toolbars;
    protected ATFInternalNodeFilter internalFilter = new ATFInternalNodeFilter();
    protected nsIDOMDocument document = null;
    protected boolean loading = true;
    protected MozNetworkMonitorAdapter netMonAdapter = null;
    private DOMEventsPublisher domEventsPublisher = new DOMEventsPublisher(this);
    protected DOMNodeSelection selection = new DOMNodeSelection();
    protected ListenerList selectionListeners = new ListenerList();
    protected boolean controlSelectEnabled = false;
    protected SelectionBox selectionBox = null;
    protected MozillaBrowserListener browserListener = new MozillaBrowserListener();
    protected OpenWindowListener openManager = new PopupWindowBrowserListener(new IShellProvider(){

        public Shell getShell() {
            return MozBrowserEditor.this.getSite().getShell();
        }
    });
    protected CloseBrowserManager closeManager = new CloseBrowserManager();
    nsICacheService cacheService = null;
    protected HashMap adapterCache = new HashMap();
    protected nsIDOMEventListener cancelPropagationListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            try {
                if (MozBrowserEditor.this.clickSelectAction.isChecked() && MozBrowserEditor.this.controlSelectEnabled) {
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected nsIDOMEventListener highlightElementListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            try {
                if (MozBrowserEditor.this.clickSelectAction.isChecked() && MozBrowserEditor.this.controlSelectEnabled) {
                    event.stopPropagation();
                    event.preventDefault();
                    if ("mouseover".equals(event.getType()) || "mousemove".equals(event.getType())) {
                        nsIDOMElement element;
                        nsIDOMNode target = (nsIDOMNode)event.getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
                        if (target.getNodeType() == 1 && !"___ATF_INTERNAL".equals((element = (nsIDOMElement)target.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("class"))) {
                            MozBrowserEditor.this.highlightElement(element);
                        }
                    } else if ("mouseout".equals(event.getType())) {
                        MozBrowserEditor.this.selectionBox.hide();
                    }
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected nsIDOMEventListener revealSelectionListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            try {
                if (MozBrowserEditor.this.clickSelectAction.isChecked() && MozBrowserEditor.this.controlSelectEnabled) {
                    nsIDOMElement element;
                    event.stopPropagation();
                    event.preventDefault();
                    nsIDOMNode target = (nsIDOMNode)event.getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
                    if (target.getNodeType() == 1 && !"___ATF_INTERNAL".equals((element = (nsIDOMElement)target.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("class"))) {
                        MozBrowserEditor.this.changeSelection(target);
                    }
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected nsIDOMEventListener keyDownListener = new nsIDOMEventListener(){

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }

        public void handleEvent(nsIDOMEvent event) {
            try {
                nsIDOMKeyEvent keyEvent = (nsIDOMKeyEvent)event.queryInterface("{028e0e6e-8b01-11d3-aae7-0010838a3123}");
                if (MozBrowserEditor.this.isDocumentLoading()) {
                    return;
                }
                if (MozBrowserEditor.this.clickSelectAction.isChecked() && keyEvent.getKeyCode() == OSModifierKey.getInstance().getKeyCode()) {
                    event.stopPropagation();
                    event.preventDefault();
                    MozBrowserEditor.this.controlSelectEnabled = true;
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
    };
    protected nsIDOMEventListener keyUpListener = new nsIDOMEventListener(){

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }

        public void handleEvent(nsIDOMEvent event) {
            try {
                nsIDOMKeyEvent keyEvent = (nsIDOMKeyEvent)event.queryInterface("{028e0e6e-8b01-11d3-aae7-0010838a3123}");
                if (MozBrowserEditor.this.isDocumentLoading()) {
                    return;
                }
                if (MozBrowserEditor.this.clickSelectAction.isChecked() && keyEvent.getKeyCode() == OSModifierKey.getInstance().getKeyCode()) {
                    event.stopPropagation();
                    event.preventDefault();
                    MozBrowserEditor.this.controlSelectEnabled = false;
                    MozBrowserEditor.this.selectionBox.hide();
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
    };
    protected nsIDOMEventListener insertNodeListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            try {
                nsIDOMMutationEvent mutEvent = (nsIDOMMutationEvent)event.queryInterface("{8e440d86-886a-4e76-9e59-c13b939c9a4b}");
                if (MozBrowserEditor.this.internalFilter.isATFInternal(mutEvent.getTarget())) {
                    event.stopPropagation();
                    event.preventDefault();
                } else {
                    MozBrowserEditor.this.domEventsPublisher.fireNodeInserted(mutEvent);
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected nsIDOMEventListener removeNodeListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            try {
                nsIDOMMutationEvent mutEvent = (nsIDOMMutationEvent)event.queryInterface("{8e440d86-886a-4e76-9e59-c13b939c9a4b}");
                if (MozBrowserEditor.this.internalFilter.isATFInternal(mutEvent.getTarget())) {
                    event.stopPropagation();
                    event.preventDefault();
                } else {
                    MozBrowserEditor.this.domEventsPublisher.fireNodeRemoved(mutEvent);
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected nsIDOMEventListener modifyAttrListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            try {
                nsIDOMMutationEvent mutEvent = (nsIDOMMutationEvent)event.queryInterface("{8e440d86-886a-4e76-9e59-c13b939c9a4b}");
                if (MozBrowserEditor.this.internalFilter.isATFInternal(mutEvent.getTarget())) {
                    event.stopPropagation();
                    event.preventDefault();
                } else if (mutEvent.getAttrChange() == 2) {
                    MozBrowserEditor.this.domEventsPublisher.fireAttributeAdded(mutEvent);
                } else if (mutEvent.getAttrChange() == 3) {
                    MozBrowserEditor.this.domEventsPublisher.fireAttributeRemoved(mutEvent);
                } else if (mutEvent.getAttrChange() == 1) {
                    MozBrowserEditor.this.domEventsPublisher.fireAttributeModified(mutEvent);
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };

    public MozBrowserEditor() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().postEvent((IApplicationEvent)new BrowserCreatedEvent(this));
    }

    public Browser getMozillaBrowser() {
        return this.browser;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof MozBrowserEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
        } else if (input instanceof IFileEditorInput) {
            try {
                this.setSite((IWorkbenchPartSite)site);
                this.setInput(new MozBrowserEditorInput((IFileEditorInput)input));
            }
            catch (Exception exception) {
                throw new PartInitException("Error opening IFileEditorInput!");
            }
        } else {
            throw new PartInitException("Invalid input to MozBrowserEditor!");
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 1;
        displayArea.setLayout((Layout)gridLayout);
        this.navBar = new NavigationBar(displayArea, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        this.navBar.setLayoutData(data);
        Label upperBarSeparator = new Label(displayArea, 259);
        data = new GridData(768);
        data.horizontalSpan = 1;
        upperBarSeparator.setLayoutData((Object)data);
        this.createActions();
        this.navBar.setBackAction((IAction)this.backAction);
        this.navBar.setForwardAction((IAction)this.forwardAction);
        this.navBar.setRefreshAction((IAction)this.refreshAction);
        this.navBar.setStopAction((IAction)this.stopAction);
        this.navBar.setGoAction((IAction)this.goAction);
        this.navBar.addExtensionAction((IAction)this.clickSelectAction);
        this.navBar.addMenuExtensionAction((IAction)this.clearCacheAction);
        this.browser = new Browser(displayArea, 32768);
        this.netMonAdapter = new MozNetworkMonitorAdapter(this);
        this.netMonAdapter.connect();
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.browser.setLayoutData((Object)data);
        this.toolbars = ToolbarExtensionManager.create(this.navBar, displayArea, this);
        Label lowerBarSeparator = new Label(displayArea, 259);
        data = new GridData(768);
        data.horizontalSpan = 1;
        lowerBarSeparator.setLayoutData((Object)data);
        this.statusBar = new StatusBar(displayArea, 0);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.statusBar.setLayoutData(data);
        this.browserListener.init();
        this.browser.addOpenWindowListener(this.openManager);
        this.browser.addCloseWindowListener((CloseWindowListener)this.closeManager);
        this.getSite().getPage().addPartListener((IPartListener)this.closeManager);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MozBrowserEditor.this.netMonAdapter.disconnect();
                MozBrowserEditor.this.browser.removeOpenWindowListener(MozBrowserEditor.this.openManager);
                MozBrowserEditor.this.browser.removeCloseWindowListener((CloseWindowListener)MozBrowserEditor.this.closeManager);
                MozBrowserEditor.this.getSite().getPage().removePartListener((IPartListener)MozBrowserEditor.this.closeManager);
                MozBrowserEditor.this.browser.removeDisposeListener((DisposeListener)this);
            }
        });
        this.goToURL(((MozBrowserEditorInput)this.getEditorInput()).getURL());
        this.stopAction.setEnabled(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected void createActions() {
        this.backAction = new Action(null, 1){

            public void run() {
                MozBrowserEditor.this.browser.back();
            }
        };
        this.backAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/e_back.gif"));
        this.backAction.setDisabledImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/d_back.gif"));
        this.backAction.setEnabled(false);
        this.forwardAction = new Action(null, 1){

            public void run() {
                MozBrowserEditor.this.browser.forward();
            }
        };
        this.forwardAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/e_forward.gif"));
        this.forwardAction.setDisabledImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/d_forward.gif"));
        this.forwardAction.setEnabled(false);
        this.refreshAction = new Action(null, 1){

            public void run() {
                MozBrowserEditor.this.browser.refresh();
            }
        };
        this.refreshAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/e_refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/d_refresh.gif"));
        this.stopAction = new Action(null, 1){

            public void run() {
                MozBrowserEditor.this.browser.stop();
            }
        };
        this.stopAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/e_stop.gif"));
        this.stopAction.setDisabledImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/d_stop.gif"));
        this.stopAction.setEnabled(false);
        this.goAction = new Action(null, 1){

            public void run() {
                MozBrowserEditor.this.goToURL(MozBrowserEditor.this.navBar.getLocationURL());
            }
        };
        this.goAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/e_go.gif"));
        this.goAction.setDisabledImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/d_go.gif"));
        this.clickSelectAction = new Action(null, 2){

            public void run() {
                MozBrowserEditor.this.controlSelectEnabled = false;
                MozBrowserEditor.this.selectionBox.hide();
            }
        };
        this.clickSelectAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/inspector/revealBySelection.gif"));
        String modifierKeyText = OSModifierKey.getInstance().getKeyCode() == 17L ? "CTRL" : "CMD";
        this.clickSelectAction.setToolTipText("Enable/Disable " + modifierKeyText + "+Click element selection in the browser.");
        this.clickSelectAction.setChecked(true);
        this.clearCacheAction = new Action(null, 1){

            public void run() {
                MozBrowserEditor.this.clearCache();
                this.setEnabled(false);
            }
        };
        this.clearCacheAction.setText("Clear Cache");
        this.clearCacheAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/e_clearCache.gif"));
        this.clearCacheAction.setDisabledImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/browser/d_clearCache.gif"));
        this.clearCacheAction.setToolTipText("Clear the Browser's cache.");
        this.clearCacheAction.setEnabled(true);
    }

    public void goToURL(String url) {
        try {
            this.browser.setUrl(url);
        }
        catch (XPCOMException xPCOMException) {
            this.browser.setUrl(DEFAULT_URL);
        }
    }

    public void clearCache() {
        if (this.cacheService == null) {
            this.cacheService = (nsICacheService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/network/cache-service;1", "{de114eb4-29fc-4959-b2f7-2d03eb9bc771}");
        }
        this.cacheService.evictEntries(1);
        this.cacheService.evictEntries(2);
    }

    public void setFocus() {
        if (!this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }

    public Object getAdapter(Class adapterType) {
        IPage pageAdapter;
        Object adapterObj = null;
        if (this.adapterCache.containsKey(adapterType) && (adapterObj = (Object)this.adapterCache.get(adapterType)) instanceof IPage && (pageAdapter = (IPage)adapterObj).getControl() != null && pageAdapter.getControl().isDisposed()) {
            this.adapterCache.remove(adapterType);
            adapterObj = null;
        }
        if (adapterObj == null) {
            adapterObj = BrowserViewExtensionManager.getInstance().getAdapter(this, adapterType);
            if (adapterObj != null) {
                this.adapterCache.put(adapterType, adapterObj);
            } else if (adapterType == IJavaScriptConsoleViewAdapter.class) {
                adapterObj = new IJavaScriptConsoleViewAdapter(){

                    public IJavaScriptConsole getJavaScriptConsole() {
                        return MozBrowserEditor.this.createJavaScriptConsole();
                    }
                };
            } else {
                if (adapterType == nsIWebBrowser.class) {
                    return this.browser.getWebBrowser();
                }
                if (adapterType == nsIDOMWindow.class) {
                    return ((nsIWebBrowser)this.browser.getWebBrowser()).getContentDOMWindow();
                }
                if (adapterType == Browser.class) {
                    return this.browser;
                }
                adapterObj = adapterType == IDOMNodeSelection.class ? this.selection : super.getAdapter(adapterType);
            }
        }
        return adapterObj;
    }

    protected IJavaScriptConsole createJavaScriptConsole() {
        JavaScriptConsolePage jsConsole = new JavaScriptConsolePage();
        JavaScriptConsoleListener consoleListener = new JavaScriptConsoleListener(jsConsole);
        try {
            nsIConsoleService consoleService = (nsIConsoleService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/consoleservice;1", "{883472a0-ea9b-11da-8ad9-0800200c9a66}");
            consoleService.registerListener((nsIConsoleListener)consoleListener);
            nsIConsoleMessage[][] messageArray = new nsIConsoleMessage[1][];
            consoleService.getMessageArray((nsIConsoleMessage[][])messageArray, null);
            int i = 0;
            while (i < messageArray[0].length) {
                jsConsole.logConsoleMessage(messageArray[0][i]);
                ++i;
            }
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
        }
        return jsConsole;
    }

    public void dispose() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().postEvent((IApplicationEvent)new BrowserDisposedEvent(this));
        if (this.document != null) {
            this.unhookAllMouseEvents();
            this.unhookKeyEvents();
            this.unhookDOMMutationEvents();
        }
        this.netMonAdapter = null;
        this.domEventsPublisher.dispose();
        this.changeSelection(null);
        this.selectionBox = null;
        this.getSite().setSelectionProvider(null);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    protected void highlightElement(nsIDOMElement element) {
        this.selectionBox.highlight(element);
        nsIDOMElement node = element;
        this.fireHoverSelection(new IDOMNodeSelection((nsIDOMNode)node){
            private final /* synthetic */ nsIDOMNode val$node;
            {
                this.val$node = nsIDOMNode2;
            }

            public boolean isEmpty() {
                return false;
            }

            public nsIDOMNode getSelectedNode() {
                return this.val$node;
            }
        });
    }

    protected void fireHoverSelection(IDOMNodeSelection hovered) {
        int i = 0;
        while (i < this.toolbars.size()) {
            ((IBrowserToolbar)this.toolbars.get(i)).setHoverSelection(hovered);
            ++i;
        }
    }

    protected void revealSelection() {
        nsIDOMNode selectedNode = this.selection.getSelectedNode();
        if (selectedNode.getNodeType() == 1) {
            try {
                nsIDOMNSHTMLElement nsElement = (nsIDOMNSHTMLElement)selectedNode.queryInterface("{7f142f9a-fba7-4949-93d6-cf08a974ac51}");
                nsElement.scrollIntoView(false);
            }
            catch (Exception exception) {}
            this.selectionBox.flash((nsIDOMElement)selectedNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"));
        }
    }

    protected void changeSelection(nsIDOMNode selectedNode) {
        if (selectedNode == null) {
            if (!this.selection.isEmpty()) {
                this.selection.setSelectedNode(null);
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
            }
        } else {
            if (this.selection.isEmpty()) {
                this.selection.setSelectedNode(selectedNode);
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
            } else {
                nsIDOMNode currentSelection = this.selection.getSelectedNode();
                if (!currentSelection.equals(selectedNode)) {
                    this.selection.setSelectedNode(selectedNode);
                    this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
                }
            }
            this.revealSelection();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this || selection == null) {
            return;
        }
        if (this != this.getSite().getPage().getActiveEditor()) {
            return;
        }
        if (selection instanceof IDOMNodeSelection) {
            if (selection.isEmpty()) {
                this.changeSelection(null);
            } else {
                nsIDOMNode selectedNode = ((IDOMNodeSelection)selection).getSelectedNode();
                if (selectedNode == null) {
                    this.changeSelection(null);
                } else {
                    this.changeSelection(selectedNode);
                }
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.changeSelection(null);
        } else if (selection instanceof IDOMNodeSelection) {
            nsIDOMNode externalSelection = ((IDOMNodeSelection)selection).getSelectedNode();
            this.changeSelection(externalSelection);
        }
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
        i = 0;
        while (i < this.toolbars.size()) {
            ((IBrowserToolbar)this.toolbars.get(i)).setNodeSelection((IDOMNodeSelection)event.getSelection());
            ++i;
        }
    }

    public nsIDOMDocument getDocument() {
        return this.document;
    }

    public boolean isDocumentLoading() {
        return this.loading;
    }

    private void hookDOMEventListener(String eventType, nsIDOMEventListener listener, nsIDOMDocument document, boolean hookSubDocs) {
        nsIDOMEventTarget docEventTarget = (nsIDOMEventTarget)document.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        docEventTarget.addEventListener(eventType, listener, true);
        if (!hookSubDocs) {
            return;
        }
        nsIDOMNodeList frames = document.getElementsByTagName("FRAME");
        int i = 0;
        while ((long)i < frames.getLength()) {
            nsIDOMHTMLFrameElement frame = (nsIDOMHTMLFrameElement)frames.item((long)i).queryInterface("{a6cf90b9-15b3-11d2-932e-00805f8add32}");
            if (frame.getContentDocument() != null) {
                this.hookDOMEventListener(eventType, listener, frame.getContentDocument(), hookSubDocs);
            }
            ++i;
        }
        nsIDOMNodeList iframes = document.getElementsByTagName("IFRAME");
        int i2 = 0;
        while ((long)i2 < iframes.getLength()) {
            nsIDOMHTMLIFrameElement iframe = (nsIDOMHTMLIFrameElement)iframes.item((long)i2).queryInterface("{a6cf90ba-15b3-11d2-932e-00805f8add32}");
            if (iframe.getContentDocument() != null) {
                this.hookDOMEventListener(eventType, listener, iframe.getContentDocument(), hookSubDocs);
            }
            ++i2;
        }
    }

    private void unhookDOMEventListener(String eventType, nsIDOMEventListener listener, nsIDOMDocument document, boolean unhookSubDocs) {
        nsIDOMEventTarget docEventTarget = (nsIDOMEventTarget)document.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        try {
            docEventTarget.removeEventListener(eventType, listener, true);
        }
        catch (XPCOMException e) {
            MozIDEUIPlugin.debug("ignored " + e.getMessage());
        }
        if (!unhookSubDocs) {
            return;
        }
        nsIDOMNodeList frames = document.getElementsByTagName("FRAME");
        int i = 0;
        while ((long)i < frames.getLength()) {
            nsIDOMHTMLFrameElement frame = (nsIDOMHTMLFrameElement)frames.item((long)i).queryInterface("{a6cf90b9-15b3-11d2-932e-00805f8add32}");
            if (frame.getContentDocument() != null) {
                this.unhookDOMEventListener(eventType, listener, frame.getContentDocument(), unhookSubDocs);
            }
            ++i;
        }
        nsIDOMNodeList iframes = document.getElementsByTagName("IFRAME");
        int i2 = 0;
        while ((long)i2 < iframes.getLength()) {
            nsIDOMHTMLIFrameElement iframe = (nsIDOMHTMLIFrameElement)iframes.item((long)i2).queryInterface("{a6cf90ba-15b3-11d2-932e-00805f8add32}");
            if (iframe.getContentDocument() != null) {
                this.unhookDOMEventListener(eventType, listener, iframe.getContentDocument(), unhookSubDocs);
            }
            ++i2;
        }
    }

    protected void hookAllMouseEvents() {
        this.hookDOMEventListener("mousedown", this.revealSelectionListener, this.document, true);
        this.hookDOMEventListener("mouseover", this.highlightElementListener, this.document, true);
        this.hookDOMEventListener("mousemove", this.highlightElementListener, this.document, true);
        this.hookDOMEventListener("mouseup", this.cancelPropagationListener, this.document, true);
        this.hookDOMEventListener("click", this.cancelPropagationListener, this.document, true);
        this.hookDOMEventListener("mouseout", this.highlightElementListener, this.document, true);
    }

    protected void unhookAllMouseEvents() {
        this.unhookDOMEventListener("mousedown", this.revealSelectionListener, this.document, true);
        this.unhookDOMEventListener("mouseover", this.highlightElementListener, this.document, true);
        this.unhookDOMEventListener("mousemove", this.highlightElementListener, this.document, true);
        this.unhookDOMEventListener("mouseup", this.cancelPropagationListener, this.document, true);
        this.unhookDOMEventListener("click", this.cancelPropagationListener, this.document, true);
        this.unhookDOMEventListener("mouseout", this.highlightElementListener, this.document, true);
    }

    protected void hookKeyEvents() {
        this.hookDOMEventListener("keydown", this.keyDownListener, this.document, false);
        this.hookDOMEventListener("keyup", this.keyUpListener, this.document, false);
    }

    protected void unhookKeyEvents() {
        this.unhookDOMEventListener("keydown", this.keyDownListener, this.document, false);
        this.unhookDOMEventListener("keyup", this.keyUpListener, this.document, false);
    }

    protected void hookDOMMutationEvents() {
        this.hookDOMEventListener("DOMNodeInserted", this.insertNodeListener, this.document, true);
        this.hookDOMEventListener("DOMNodeRemoved", this.removeNodeListener, this.document, true);
        this.hookDOMEventListener("DOMAttrModified", this.modifyAttrListener, this.document, true);
    }

    protected void unhookDOMMutationEvents() {
        this.unhookDOMEventListener("DOMNodeInserted", this.insertNodeListener, this.document, true);
        this.unhookDOMEventListener("DOMNodeRemoved", this.removeNodeListener, this.document, true);
        this.unhookDOMEventListener("DOMAttrModified", this.modifyAttrListener, this.document, true);
    }

    public void setSelection(IDOMNodeSelection selection) {
        if (!selection.isEmpty()) {
            this.changeSelection(selection.getSelectedNode());
        }
    }

    public WebBrowserType getType() {
        return MOZILLA_BROWSER;
    }

    protected class CloseBrowserManager
    implements CloseWindowListener,
    IPartListener {
        protected boolean partClosing = false;

        protected CloseBrowserManager() {
        }

        public void close(WindowEvent event) {
            IWorkbenchPage page = MozBrowserEditor.this.getSite().getPage();
            if (!this.partClosing) {
                page.closeEditor((IEditorPart)MozBrowserEditor.this, false);
            }
        }

        public void partClosed(IWorkbenchPart part) {
            this.partClosing = part == MozBrowserEditor.this;
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    protected class DOMNodeSelection
    implements IDOMNodeSelection {
        protected nsIDOMNode selectedNode = null;

        protected DOMNodeSelection() {
        }

        public boolean isEmpty() {
            return this.selectedNode == null;
        }

        public nsIDOMNode getSelectedNode() {
            return this.selectedNode;
        }

        public void setSelectedNode(nsIDOMNode selectedNode) {
            this.selectedNode = selectedNode;
        }
    }

    protected class MozillaBrowserListener
    implements ProgressListener,
    LocationListener,
    StatusTextListener,
    nsIDOMEventListener {
        private static final String UNLOAD = "unload";
        private static final String PAGEHIDE = "pagehide";
        private static final String DOM_CONTENT_LOADED = "DOMContentLoaded";
        private static final String PAGESHOW = "pageshow";
        private boolean changed;

        protected MozillaBrowserListener() {
        }

        public void init() {
            MozBrowserEditor.this.getMozillaBrowser().addLocationListener((LocationListener)this);
            MozBrowserEditor.this.getMozillaBrowser().addProgressListener((ProgressListener)this);
            MozBrowserEditor.this.getMozillaBrowser().addStatusTextListener((StatusTextListener)this);
            MozBrowserEditor.this.getMozillaBrowser().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MozBrowserEditor.this.getMozillaBrowser().removeLocationListener((LocationListener)MozillaBrowserListener.this);
                    MozBrowserEditor.this.getMozillaBrowser().removeProgressListener((ProgressListener)MozillaBrowserListener.this);
                    MozBrowserEditor.this.getMozillaBrowser().removeStatusTextListener((StatusTextListener)MozillaBrowserListener.this);
                    MozBrowserEditor.this.getMozillaBrowser().removeDisposeListener((DisposeListener)this);
                }
            });
        }

        public void changing(LocationEvent event) {
            this.changed = false;
        }

        public void changed(LocationEvent event) {
            this.changed = true;
            if (event.top) {
                MozBrowserEditor.this.setTitleToolTip(event.location);
                MozBrowserEditor.this.navBar.setLocationURL(event.location);
                MozBrowserEditor.this.stopAction.setEnabled(true);
                MozBrowserEditorInput input = (MozBrowserEditorInput)MozBrowserEditor.this.getEditorInput();
                input.setURL(event.location);
                MozBrowserEditor.this.changeSelection(null);
                MozBrowserEditor.this.domEventsPublisher.locationChanged(event.location);
            }
        }

        public void changed(ProgressEvent event) {
            if (event.total > 0) {
                int ratio = event.current * 100 / event.total;
                MozBrowserEditor.this.statusBar.showProgress(ratio);
            }
        }

        public void completed(ProgressEvent event) {
            if (!this.changed) {
                MozBrowserEditor.this.browser.redraw();
                MozBrowserEditor.this.navBar.setLocationURL(MozBrowserEditor.this.getMozillaBrowser().getUrl());
            }
            if (event.widget instanceof Browser) {
                boolean isInitiated;
                nsIDOMWindow window = ((nsIWebBrowser)MozBrowserEditor.this.browser.getWebBrowser()).getContentDOMWindow();
                nsIDOMEventTarget windowEventTarget = (nsIDOMEventTarget)window.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
                windowEventTarget.addEventListener(PAGESHOW, (nsIDOMEventListener)this, true);
                windowEventTarget.addEventListener(DOM_CONTENT_LOADED, (nsIDOMEventListener)this, true);
                windowEventTarget.addEventListener(PAGEHIDE, (nsIDOMEventListener)this, true);
                windowEventTarget.addEventListener(UNLOAD, (nsIDOMEventListener)this, true);
                MozBrowserEditor.this.backAction.setEnabled(MozBrowserEditor.this.browser.isBackEnabled());
                MozBrowserEditor.this.forwardAction.setEnabled(MozBrowserEditor.this.browser.isForwardEnabled());
                MozBrowserEditor.this.stopAction.setEnabled(false);
                MozBrowserEditor.this.statusBar.progressDone();
                MozBrowserEditor.this.statusBar.setStatusText("");
                IWorkbenchPage page = MozBrowserEditor.this.getSite().getPage();
                boolean bl = isInitiated = page.getReference((IWorkbenchPart)MozBrowserEditor.this).getPart(false) != null;
                if (isInitiated && !page.isPartVisible((IWorkbenchPart)MozBrowserEditor.this)) {
                    page.bringToTop((IWorkbenchPart)MozBrowserEditor.this);
                }
                MozBrowserEditor.this.setFocus();
                MozBrowserEditor.this.clearCacheAction.setEnabled(true);
            }
        }

        public void changed(StatusTextEvent event) {
            MozBrowserEditor.this.statusBar.setStatusText(event.text);
        }

        public void handleEvent(nsIDOMEvent event) {
            String eventType = event.getType();
            if (PAGESHOW.equals(eventType) || DOM_CONTENT_LOADED.equals(eventType)) {
                nsIDOMWindow topWindow = ((nsIWebBrowser)MozBrowserEditor.this.browser.getWebBrowser()).getContentDOMWindow();
                nsIDOMEventTarget eventTarget = event.getTarget();
                nsIDOMDocument documentEventTarget = (nsIDOMDocument)eventTarget.queryInterface("{a6cf9075-15b3-11d2-932e-00805f8add32}");
                boolean isTop = topWindow.getDocument().equals(documentEventTarget);
                if (isTop) {
                    String title;
                    nsIDOMNode node;
                    nsIDOMNodeList titleNodes;
                    MozBrowserEditor.this.loading = false;
                    MozBrowserEditor.this.document = topWindow.getDocument();
                    if (MozBrowserEditor.this.document != null & MozBrowserEditor.this.document.getElementsByTagName("TITLE") != null && (titleNodes = MozBrowserEditor.this.document.getElementsByTagName("TITLE")).getLength() == 1L && (node = titleNodes.item(0L)).getFirstChild() != null && !(title = node.getFirstChild().getNodeValue()).equals("")) {
                        title = title.length() > 20 ? String.valueOf(title.substring(0, 20)) + "..." : title;
                        MozBrowserEditor.this.setPartName(title);
                    }
                    try {
                        event.getCurrentTarget().removeEventListener(PAGESHOW, (nsIDOMEventListener)this, true);
                    }
                    catch (XPCOMException xPCOMException) {}
                    try {
                        event.getCurrentTarget().removeEventListener(DOM_CONTENT_LOADED, (nsIDOMEventListener)this, true);
                    }
                    catch (XPCOMException xPCOMException) {}
                    MozBrowserEditor.this.selectionBox = new SelectionBox(MozBrowserEditor.this.getDocument());
                    MozBrowserEditor.this.hookDOMMutationEvents();
                    MozBrowserEditor.this.hookAllMouseEvents();
                    MozBrowserEditor.this.hookKeyEvents();
                }
                DOMDocumentEvent e = new DOMDocumentEvent((IWebBrowser)MozBrowserEditor.this, documentEventTarget, isTop, "org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent.load");
                MozBrowserEditor.this.domEventsPublisher.documentLoaded(e);
            } else if (PAGEHIDE.equals(eventType) || UNLOAD.equals(eventType)) {
                nsIDOMWindow topWindow = ((nsIWebBrowser)MozBrowserEditor.this.browser.getWebBrowser()).getContentDOMWindow();
                nsIDOMEventTarget eventTarget = event.getTarget();
                nsIDOMDocument documentEventTarget = (nsIDOMDocument)eventTarget.queryInterface("{a6cf9075-15b3-11d2-932e-00805f8add32}");
                boolean isTop = topWindow.getDocument().equals(documentEventTarget);
                if (isTop) {
                    MozBrowserEditor.this.loading = true;
                }
                DOMDocumentEvent e = new DOMDocumentEvent((IWebBrowser)MozBrowserEditor.this, documentEventTarget, isTop, "org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent.unload");
                MozBrowserEditor.this.domEventsPublisher.documentUnloaded(e);
                if (isTop) {
                    try {
                        event.getCurrentTarget().removeEventListener(PAGEHIDE, (nsIDOMEventListener)this, true);
                    }
                    catch (XPCOMException xPCOMException) {}
                    try {
                        event.getCurrentTarget().removeEventListener(UNLOAD, (nsIDOMEventListener)this, true);
                    }
                    catch (XPCOMException xPCOMException) {}
                    if (MozBrowserEditor.this.document != null) {
                        MozBrowserEditor.this.unhookDOMMutationEvents();
                        MozBrowserEditor.this.unhookAllMouseEvents();
                        MozBrowserEditor.this.unhookKeyEvents();
                        MozBrowserEditor.this.document = null;
                    }
                }
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    }

    protected static class OSModifierKey {
        private static OSModifierKey instance = new OSModifierKey();
        private long osModifierKeyCode = SWT.getPlatform() == "carbon" ? 224L : 17L;

        private OSModifierKey() {
        }

        public static OSModifierKey getInstance() {
            return instance;
        }

        public long getKeyCode() {
            return this.osModifierKeyCode;
        }
    }
}

