/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserDialog;
import org.eclipse.atf.mozilla.ide.ui.browser.util.MozBrowserUtil;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

class PopupWindowBrowserListener
implements OpenWindowListener {
    protected static final String DIALOG_MSG = "The browser is attempting to open a new window. Opening as an Editor will allow the use of the browser tools, such as the DOM Inspector. Opening as a Dialog will open the browser in a separate window. By default, the popup will be ignored.\n\nHow would you like to handle?";
    protected static final String DIALOG_TITLE = "Popup browser window detected.";
    protected static final String DIALOG_TGL_MSG = "Remember my decision";
    protected static final String AS_EDITOR_BUTTON_LABEL = "Open as Editor";
    protected static final String AS_DIALOG_BUTTON_LABEL = "Open as Dialog";
    protected static final String IGNORE_BUTTON_LABEL = "Ignore";
    protected static final int AS_EDITOR_BUTTON_ID = 0;
    protected static final int AS_DIALOG_BUTTON_ID = 1;
    protected static final int IGNORE_BUTTON_ID = 2;
    protected IShellProvider shellProvider = null;

    public PopupWindowBrowserListener(IShellProvider shellProvider) {
        this.shellProvider = shellProvider;
    }

    public void open(WindowEvent event) {
        final IPreferenceStore store = MozIDEUIPlugin.getDefault().getPreferenceStore();
        String prefValue = store.getString("org.eclipse.atf.mozilla.ide.uipopupHandling");
        if (prefValue.equals("prompt")) {
            Shell parentShell = this.shellProvider.getShell();
            MessageDialogWithToggle d = new MessageDialogWithToggle(parentShell, DIALOG_TITLE, null, DIALOG_MSG, 3, new String[]{AS_EDITOR_BUTTON_LABEL, AS_DIALOG_BUTTON_LABEL, IGNORE_BUTTON_LABEL}, 2, DIALOG_TGL_MSG, false){

                protected void buttonPressed(int buttonId) {
                    if (this.getToggleState()) {
                        switch (buttonId - 256) {
                            case 0: {
                                store.setValue("org.eclipse.atf.mozilla.ide.uipopupHandling", "editor");
                                break;
                            }
                            case 1: {
                                store.setValue("org.eclipse.atf.mozilla.ide.uipopupHandling", "dialog");
                                break;
                            }
                            case 2: {
                                store.setValue("org.eclipse.atf.mozilla.ide.uipopupHandling", "ignore");
                            }
                        }
                    }
                    this.setReturnCode(buttonId);
                    this.close();
                }
            };
            int returnCode = d.open() - 256;
            switch (returnCode) {
                case 0: {
                    this.openAsEditor(event);
                    break;
                }
                case 1: {
                    this.openAsDialog(event);
                    break;
                }
                default: {
                    event.browser = null;
                    break;
                }
            }
        } else if (prefValue.equals("editor")) {
            this.openAsEditor(event);
        } else if (prefValue.equals("dialog")) {
            this.openAsDialog(event);
        }
    }

    protected void openAsEditor(WindowEvent event) {
        try {
            Browser b;
            IWorkbenchPage page = MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IWebBrowser wb = MozBrowserUtil.openMozillaBrowser("about:blank", page);
            event.browser = b = (Browser)wb.getAdapter(Browser.class);
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
        }
    }

    protected void openAsDialog(WindowEvent event) {
        Browser b;
        MozBrowserDialog mozDialog = new MozBrowserDialog(this.shellProvider.getShell());
        mozDialog.setBlockOnOpen(false);
        mozDialog.open();
        mozDialog.getShell().setSize(300, 300);
        event.browser = b = mozDialog.getMozillaBrowser();
    }
}

