/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser.toolbar;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class NavigationBar
extends Composite {
    protected static final String BACK_TOOL = "BACK";
    protected static final String FORWARD_TOOL = "FORWARD";
    protected static final String REFRESH_TOOL = "REFRESH";
    protected static final String STOP_TOOL = "STOP";
    protected static final String GO_TOOL = "GO";
    protected static final String EXTENSION_TOOL = "EXTENSION";
    protected ToolBarManager navigationTBManager = null;
    protected Text location = null;
    protected ToolBarManager extensibleTBManager = null;
    protected ToolBarManager extensibleMenuTBManager = null;
    protected MenuManager extensibleMenuManager = null;

    public NavigationBar(Composite parent, int style) {
        super(parent, style);
        this.createUI();
    }

    protected void createUI() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        this.navigationTBManager = new ToolBarManager(0x800000);
        this.navigationTBManager.add((IContributionItem)new GroupMarker(BACK_TOOL));
        this.navigationTBManager.add((IContributionItem)new GroupMarker(FORWARD_TOOL));
        this.navigationTBManager.add((IContributionItem)new GroupMarker(REFRESH_TOOL));
        this.navigationTBManager.add((IContributionItem)new GroupMarker(STOP_TOOL));
        this.navigationTBManager.createControl((Composite)this);
        Label labelAddress = new Label((Composite)this, 4);
        labelAddress.setText("Address");
        this.location = new Text((Composite)this, 2048);
        this.location.setText("http://");
        GridData data = new GridData(768);
        this.location.setLayoutData((Object)data);
        this.location.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                IContributionItem item = NavigationBar.this.extensibleTBManager.find("GOACTION");
                if (item != null) {
                    ((ActionContributionItem)item).getAction().run();
                }
            }
        });
        this.extensibleTBManager = new ToolBarManager(0x800000){

            protected void relayout(ToolBar layoutBar, int oldCount, int newCount) {
                if (oldCount != newCount) {
                    layoutBar.getParent().layout();
                } else {
                    super.relayout(layoutBar, oldCount, newCount);
                }
            }
        };
        this.extensibleTBManager.add((IContributionItem)new GroupMarker(GO_TOOL));
        this.extensibleTBManager.add((IContributionItem)new Separator(EXTENSION_TOOL));
        this.extensibleTBManager.createControl((Composite)this);
        this.extensibleMenuTBManager = new ToolBarManager(0x800000);
        Action openExtensibleMenuAction = new Action(){

            public void run() {
                Menu aMenu = NavigationBar.this.extensibleMenuManager.createContextMenu((Control)NavigationBar.this);
                Point toolbarSize = NavigationBar.this.extensibleMenuTBManager.getControl().getSize();
                Point location = NavigationBar.this.extensibleMenuTBManager.getControl().toDisplay(0, toolbarSize.y);
                aMenu.setLocation(location.x, location.y);
                aMenu.setVisible(true);
            }
        };
        openExtensibleMenuAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("SHOWMENU_IMG_ID"));
        this.extensibleMenuTBManager.add((IAction)openExtensibleMenuAction);
        this.extensibleMenuTBManager.createControl((Composite)this);
        this.extensibleMenuManager = new MenuManager("NavBarMenu", "NavBarMenu");
    }

    public void setLocationURL(String url) {
        this.location.setText(url);
    }

    public String getLocationURL() {
        return this.location.getText();
    }

    public void setBackAction(IAction action) {
        this.setAction(action, BACK_TOOL);
    }

    public void setForwardAction(IAction action) {
        this.setAction(action, FORWARD_TOOL);
    }

    public void setRefreshAction(IAction action) {
        this.setAction(action, REFRESH_TOOL);
    }

    public void setStopAction(IAction action) {
        this.setAction(action, STOP_TOOL);
    }

    public void setGoAction(IAction action) {
        this.setAction(action, GO_TOOL);
    }

    protected void setAction(IAction action, String group) {
        action.setId(String.valueOf(group) + "ACTION");
        if (group == GO_TOOL) {
            IContributionItem item = this.extensibleTBManager.find(action.getId());
            if (item != null) {
                this.extensibleTBManager.remove(item);
            }
            this.extensibleTBManager.appendToGroup(GO_TOOL, action);
            this.extensibleTBManager.update(true);
        } else {
            IContributionItem item = this.navigationTBManager.find(action.getId());
            if (item != null) {
                this.navigationTBManager.remove(item);
            }
            this.navigationTBManager.appendToGroup(group, action);
            this.navigationTBManager.update(true);
        }
    }

    public void addExtensionAction(IAction action) {
        this.extensibleTBManager.appendToGroup(EXTENSION_TOOL, action);
        this.extensibleTBManager.update(true);
    }

    public void removeExtensionAction(IAction action) {
        this.extensibleTBManager.remove(action.getId());
        this.extensibleTBManager.update(true);
    }

    public void addMenuExtensionAction(IAction action) {
        this.extensibleMenuManager.add(action);
    }

    public void removeMenuExtensionAction(IAction action) {
        this.extensibleMenuManager.remove(action.getId());
    }
}

