/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.common.configs;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.ui.common.SelectionProviderHandler;
import org.eclipse.atf.mozilla.ide.ui.common.configs.HTMLDOMRuleScanner;
import org.eclipse.atf.mozilla.ide.ui.source.DOMHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.mozilla.interfaces.nsIDOMComment;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HTMLDOMSourceViewerConfiguration
extends TextSourceViewerConfiguration
implements IHyperlinkDetector {
    private HTMLDOMRuleScanner scanner = null;
    private nsIDOMNode node;
    private List nodes = new ArrayList();
    private IDocument document;
    private nsIDOMDocument domDoc;
    public static final String VALIDATE = "DOM Source validates without error.";
    public static final String ERROR = "Validation error: ";
    protected int errorOffset = -1;
    private SelectionProviderHandler provider;
    private static Color DEFAULT_TAG_COLOR = new Color((Device)Display.getCurrent(), new RGB(200, 0, 0));

    public HTMLDOMSourceViewerConfiguration(SelectionProviderHandler provider) {
        this.provider = provider;
    }

    public HTMLDOMSourceViewerConfiguration() {
    }

    protected HTMLDOMRuleScanner getTagScanner() {
        if (this.scanner == null) {
            this.scanner = new HTMLDOMRuleScanner();
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(DEFAULT_TAG_COLOR)));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceView) {
        FontData fontData = new FontData("Courier New", 9, 0);
        Font font = new Font((Device)sourceView.getTextWidget().getDisplay(), fontData);
        sourceView.getTextWidget().setFont(font);
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{this};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return super.getHyperlinkPresenter(sourceViewer);
    }

    public void setNode(nsIDOMNode node) {
        this.node = node;
    }

    public nsIDOMNode getNode() {
        return this.node;
    }

    public void parse(Node node, nsIDOMNode domNode) {
        if (node.getNodeName().equals("#text")) {
            String testEmpty = node.getNodeValue().replace('\n', ' ');
            testEmpty = testEmpty.replace('\t', ' ');
            testEmpty = testEmpty.trim();
            nsIDOMText text = this.domDoc.createTextNode(node.getNodeValue());
            domNode.appendChild((nsIDOMNode)text);
        } else if (node.getNodeName().equals("#comment")) {
            nsIDOMComment comment = this.domDoc.createComment(node.getNodeValue());
            domNode.appendChild((nsIDOMNode)comment);
        } else {
            nsIDOMElement el = this.domDoc.createElement(node.getNodeName());
            domNode.appendChild((nsIDOMNode)el);
            el.setNodeValue(node.getNodeValue());
            NodeList subNodes = node.getChildNodes();
            NamedNodeMap attrs = node.getAttributes();
            int h = 0;
            while (h < attrs.getLength()) {
                el.setAttribute(attrs.item(h).getNodeName(), attrs.item(h).getNodeValue());
                ++h;
            }
            int i = 0;
            while (i < subNodes.getLength()) {
                this.parse(subNodes.item(i), (nsIDOMNode)el);
                ++i;
            }
        }
    }

    public void createTop(Node top) {
        nsIDOMElement domTop = this.domDoc.createElement(top.getNodeName());
        NodeList subs = top.getChildNodes();
        NamedNodeMap attrs = top.getAttributes();
        int h = 0;
        while (h < attrs.getLength()) {
            domTop.setAttribute(attrs.item(h).getNodeName(), attrs.item(h).getNodeValue());
            ++h;
        }
        domTop.setNodeValue(top.getNodeValue());
        int i = 0;
        while (i < subs.getLength()) {
            this.parse(subs.item(i), (nsIDOMNode)domTop);
            ++i;
        }
        this.node.getParentNode().replaceChild((nsIDOMNode)domTop, this.node);
        nsIDOMElement n = domTop;
        IDOMNodeSelection selection = new IDOMNodeSelection((nsIDOMNode)n){
            private final /* synthetic */ nsIDOMNode val$n;
            {
                this.val$n = nsIDOMNode2;
            }

            public boolean isEmpty() {
                return HTMLDOMSourceViewerConfiguration.this.node == null;
            }

            public nsIDOMNode getSelectedNode() {
                return this.val$n;
            }
        };
        this.provider.fireSelection((ISelection)selection);
        this.setNode((nsIDOMNode)domTop);
        this.clear();
        this.getNodes((nsIDOMNode)domTop, 0);
    }

    public boolean save() {
        boolean saved = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmlDoc = builder.parse(new InputSource(new StringReader(this.document.get())));
            this.domDoc = this.node.getOwnerDocument();
            this.createTop(xmlDoc.getFirstChild());
            saved = true;
            this.setErrorOffset(-1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return saved;
    }

    public String validate() {
        String returnCode = VALIDATE;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    try {
                        int lineOffset = HTMLDOMSourceViewerConfiguration.this.document.getLineOffset(exception.getLineNumber() - 1);
                        HTMLDOMSourceViewerConfiguration.this.setErrorOffset(lineOffset + exception.getColumnNumber() - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        HTMLDOMSourceViewerConfiguration.this.setErrorOffset(-1);
                    }
                }

                public void error(SAXParseException exception) throws SAXException {
                    try {
                        int lineOffset = HTMLDOMSourceViewerConfiguration.this.document.getLineOffset(exception.getLineNumber() - 1);
                        HTMLDOMSourceViewerConfiguration.this.setErrorOffset(lineOffset + exception.getColumnNumber() - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        HTMLDOMSourceViewerConfiguration.this.setErrorOffset(-1);
                    }
                }
            });
            builder.parse(new InputSource(new StringReader(this.document.get())));
            this.setErrorOffset(-1);
        }
        catch (ParserConfigurationException e) {
            returnCode = ERROR + e.getMessage();
        }
        catch (SAXException e) {
            returnCode = ERROR + e.getMessage();
        }
        catch (IOException e) {
            returnCode = ERROR + e.getMessage();
        }
        return returnCode;
    }

    public int getErrorOffset() {
        return this.errorOffset;
    }

    private void setErrorOffset(int offset) {
        this.errorOffset = offset;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void getNodes(nsIDOMNode n, int level) {
        nsIDOMNode child;
        if (n == null) {
            return;
        }
        if (n.getNodeType() == 1) {
            this.add(n);
        }
        if (n.hasChildNodes() && (child = n.getFirstChild()) != null) {
            this.getNodes(child, level + 1);
            while ((child = child.getNextSibling()) != null) {
                this.getNodes(child, level + 1);
            }
        }
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        String urlString = null;
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int urlSeparatorOffset = line.indexOf("<");
        if (urlSeparatorOffset < 0) {
            return null;
        }
        String end = line.replaceAll("\t", "");
        if (end.startsWith("</") || end.startsWith("<!")) {
            return null;
        }
        int urlOffsetInLine = urlSeparatorOffset;
        String space = line.substring(urlSeparatorOffset);
        int urlLength = space.indexOf(" ");
        if (urlLength == -1) {
            urlLength = space.length();
        }
        urlString = line.substring(urlSeparatorOffset, urlSeparatorOffset + urlLength);
        Region urlRegion = new Region(lineInfo.getOffset() + urlOffsetInLine, urlLength);
        return new IHyperlink[]{new DOMHyperlink((IRegion)urlRegion, urlString, this)};
    }

    public void clear() {
        this.nodes.clear();
    }

    public void add(nsIDOMNode n) {
        if (n.getNodeType() == 1) {
            this.nodes.add(n);
        }
    }

    public void changeSelection(IRegion region) {
        int nodeCounter = 0;
        boolean found = false;
        int i = 0;
        while (i < this.document.getNumberOfLines() && !found) {
            try {
                String currLine = this.document.get(this.document.getLineOffset(i), this.document.getLineLength(i));
                currLine = currLine.replaceAll("\t", "");
                if (currLine.startsWith("<") && !currLine.startsWith("</") && !currLine.startsWith("<!")) {
                    if (region.getOffset() >= this.document.getLineOffset(i) && region.getOffset() <= this.document.getLineOffset(i) + this.document.getLineLength(i)) {
                        found = true;
                    } else {
                        ++nodeCounter;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            ++i;
        }
        if (found) {
            final nsIDOMNode n = (nsIDOMNode)this.nodes.get(nodeCounter);
            IDOMNodeSelection selection = new IDOMNodeSelection(){

                public boolean isEmpty() {
                    return HTMLDOMSourceViewerConfiguration.this.node == null;
                }

                public nsIDOMNode getSelectedNode() {
                    return n;
                }
            };
            this.provider.fireSelection((ISelection)selection);
        }
    }
}

