/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.ArrayList;
import org.eclipse.atf.mozilla.ide.ui.css.CSSContentProvider;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.CompositeProperty;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.ComputedStyleProperty;
import org.eclipse.jface.viewers.Viewer;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMClientRect;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNSElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMViewCSS;

public class BoxModelContentProvider
extends CSSContentProvider {
    private void parseBoxModel() {
        this.nodeMap.clear();
        nsIDOMElement element = (nsIDOMElement)this.currentNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        nsIDOMNSElement nselement = (nsIDOMNSElement)element.queryInterface("{c9da11bc-32d4-425e-a91f-7e0939c39251}");
        nsIDOMClientRect elementBox = nselement.getBoundingClientRect();
        nsIDOMDocumentView documentView = (nsIDOMDocumentView)element.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
        nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
        nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(element, "");
        ArrayList<CSSProperty> boxModels = new ArrayList<CSSProperty>();
        String x_val = String.valueOf(elementBox.getTop());
        String y_val = String.valueOf(elementBox.getLeft());
        String width = String.valueOf(elementBox.getWidth());
        String height = String.valueOf(elementBox.getHeight());
        CSSProperty property = new CSSProperty("x", x_val, "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("y", y_val, "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("width", width, "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("height", height, "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("margin-top", computedStyle.getPropertyCSSValue("margin-top").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("margin-bottom", computedStyle.getPropertyCSSValue("margin-bottom").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("margin-right", computedStyle.getPropertyCSSValue("margin-right").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("margin-left", computedStyle.getPropertyCSSValue("margin-left").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("padding-top", computedStyle.getPropertyCSSValue("padding-top").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("padding-bottom", computedStyle.getPropertyCSSValue("padding-bottom").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("padding-right", computedStyle.getPropertyCSSValue("padding-right").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("padding-left", computedStyle.getPropertyCSSValue("padding-left").getCssText(), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        CompositeProperty borderTopProp = new CompositeProperty("border-top");
        borderTopProp.addProperties(new ComputedStyleProperty("border-top-width", "border-top-width"));
        borderTopProp.addProperties(new ComputedStyleProperty("border-top-style", "border-top-style"));
        borderTopProp.addProperties(new ComputedStyleProperty("border-top-color", "border-top-color"));
        property = new CSSProperty(borderTopProp.getDisplayName(), borderTopProp.getValue(this.currentNode), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        CompositeProperty borderBottomProp = new CompositeProperty("border-bottom");
        borderBottomProp.addProperties(new ComputedStyleProperty("border-bottom-width", "border-bottom-width"));
        borderBottomProp.addProperties(new ComputedStyleProperty("border-bottom-style", "border-bottom-style"));
        borderBottomProp.addProperties(new ComputedStyleProperty("border-bottom-color", "border-bottom-color"));
        property = new CSSProperty(borderBottomProp.getDisplayName(), borderBottomProp.getValue(this.currentNode), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        CompositeProperty borderRightProp = new CompositeProperty("border-right");
        borderRightProp.addProperties(new ComputedStyleProperty("border-right-width", "border-right-width"));
        borderRightProp.addProperties(new ComputedStyleProperty("border-right-style", "border-right-style"));
        borderRightProp.addProperties(new ComputedStyleProperty("border-right-color", "border-right-color"));
        property = new CSSProperty(borderRightProp.getDisplayName(), borderRightProp.getValue(this.currentNode), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        CompositeProperty borderLeftProp = new CompositeProperty("border-left");
        borderLeftProp.addProperties(new ComputedStyleProperty("border-left-width", "border-left-width"));
        borderLeftProp.addProperties(new ComputedStyleProperty("border-left-style", "border-left-style"));
        borderLeftProp.addProperties(new ComputedStyleProperty("border-left-color", "border-left-color"));
        property = new CSSProperty(borderLeftProp.getDisplayName(), borderLeftProp.getValue(this.currentNode), "", "", "");
        property.setPresent(true);
        property.setComputed(true);
        boxModels.add(property);
        property = new CSSProperty("", "", "", "", "Box Model");
        property.setProperty(false);
        this.nodeMap.put(property, boxModels);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput instanceof nsIDOMNode) {
            this.currentNode = (nsIDOMNode)newInput;
            this.parseBoxModel();
        }
    }
}

