/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.domwatcher.model;

import org.eclipse.atf.mozilla.ide.ui.domwatcher.model.IDOMEventDetailProvider;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMKeyEvent;

public class DOMKeyEventDetailProvider
implements IDOMEventDetailProvider {
    protected static final String[] KEY_SET_1 = new String[]{"CANCEL", "", "", "HELP", "", "BACK_SPACE", "TAB", "", "", "CLEAR", "RETURN", "ENTER", "", "SHIFT", "CONTROL", "ALT", "PAUSE", "CAPS_LOCK", "", "", "", "", "", "", "ESCAPE", "", "", "", "", "SPACE", "PAGE_UP", "PAGE_DOWN", "END", "HOME", "LEFT", "UP", "RIGHT", "DOWN", "", "", "", "PRINTSCREEN", "INSERT", "DELETE"};
    protected static final String[] KEY_SET_2 = new String[]{"NUMPAD0", "NUMPAD1", "NUMPAD2", "NUMPAD3", "NUMPAD4", "NUMPAD5", "NUMPAD6", "NUMPAD7", "NUMPAD8", "NUMPAD9", "MULTIPLY", "ADD", "SEPARATOR", "SUBTRACT", "DECIMAL", "DIVIDE", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "F13", "F14", "F15", "F16", "F17", "F18", "F19", "F20", "F21", "F22", "F23", "F24"};
    protected static final String[] KEY_SET_3 = new String[]{"COMMA", "", "PERIOD", "SLASH"};
    protected static final String[] KEY_SET_4 = new String[]{"OPEN_BRACKET", "BACK_SLASH", "CLOSE_BRACKET", "QUOTE"};

    public String getDetail(nsIDOMEvent event) {
        nsIDOMKeyEvent kEvent = (nsIDOMKeyEvent)event.queryInterface("{028e0e6e-8b01-11d3-aae7-0010838a3123}");
        StringBuffer details = new StringBuffer();
        if (kEvent.getShiftKey()) {
            details.append("Shift ");
        }
        if (kEvent.getCtrlKey()) {
            details.append("Ctrl ");
        }
        if (kEvent.getAltKey()) {
            details.append("Alt ");
        }
        if (kEvent.getMetaKey()) {
            details.append("Meta ");
        }
        details.append("charCode:");
        details.append(this.charCodeAsString((int)kEvent.getCharCode()));
        details.append(" keyCode:");
        details.append(this.keyCodeAsString((int)kEvent.getKeyCode()));
        return details.toString();
    }

    protected String keyCodeAsString(int keyCode) {
        if (keyCode == 0) {
            return "0";
        }
        StringBuffer code = new StringBuffer();
        code.append(keyCode);
        code.append('(');
        if (keyCode >= 3 && keyCode <= 46) {
            code.append(KEY_SET_1[keyCode - 3]);
        } else if (keyCode >= 48 && keyCode <= 57) {
            code.append((char)keyCode);
        } else if (keyCode == 59) {
            code.append(';');
        } else if (keyCode == 61) {
            code.append('=');
        } else if (keyCode >= 65 && keyCode <= 90) {
            code.append((char)keyCode);
        } else if (keyCode == 93) {
            code.append("CONTEXT_MENU");
        } else if (keyCode >= 96 && keyCode <= 135) {
            code.append(KEY_SET_2[keyCode - 96]);
        } else if (keyCode == 144) {
            code.append("NUM_LOCK");
        } else if (keyCode == 145) {
            code.append("SCROLL_LOCK");
        } else if (keyCode >= 188 && keyCode <= 191) {
            code.append(KEY_SET_3[keyCode - 188]);
        } else if (keyCode == 192) {
            code.append("BACK_QUOTE");
        } else if (keyCode >= 219 && keyCode <= 222) {
            code.append(KEY_SET_4[keyCode - 219]);
        } else if (keyCode == 224) {
            code.append("META");
        }
        code.append(')');
        return code.toString();
    }

    protected String charCodeAsString(int charCode) {
        if (charCode == 0) {
            return "0";
        }
        StringBuffer code = new StringBuffer();
        code.append(charCode);
        code.append('(');
        code.append((char)charCode);
        code.append(')');
        return code.toString();
    }
}

