/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.domwatcher.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.DOMKeyEventSetting;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.DOMMouseEventSetting;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.DOMMutationEventSetting;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.IDOMEventSetting;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.PreferencePersistedDOMEventSetting;

public class DOMWatcherSettings {
    protected static DOMWatcherSettings instance = null;
    protected HashMap eventTypeSettingsMap = new HashMap();
    protected List settings = new ArrayList();

    public static DOMWatcherSettings getInstance() {
        if (instance == null) {
            instance = new DOMWatcherSettings();
        }
        return instance;
    }

    private DOMWatcherSettings() {
        this.addSetting(new DOMMouseEventSetting("click"));
        this.addSetting(new DOMMouseEventSetting("dblclick"));
        this.addSetting(new DOMMouseEventSetting("mousedown"));
        this.addSetting(new DOMMouseEventSetting("mouseup"));
        this.addSetting(new DOMMouseEventSetting("mouseover"));
        this.addSetting(new DOMMouseEventSetting("mousemove", false));
        this.addSetting(new DOMMouseEventSetting("mouseout"));
        this.addSetting(new DOMKeyEventSetting("keypress"));
        this.addSetting(new DOMKeyEventSetting("keydown"));
        this.addSetting(new DOMKeyEventSetting("keyup"));
        this.addSetting(new PreferencePersistedDOMEventSetting("load"));
        this.addSetting(new PreferencePersistedDOMEventSetting("unload"));
        this.addSetting(new PreferencePersistedDOMEventSetting("abort"));
        this.addSetting(new PreferencePersistedDOMEventSetting("error"));
        this.addSetting(new PreferencePersistedDOMEventSetting("resize"));
        this.addSetting(new PreferencePersistedDOMEventSetting("scroll"));
        this.addSetting(new PreferencePersistedDOMEventSetting("select"));
        this.addSetting(new PreferencePersistedDOMEventSetting("change"));
        this.addSetting(new PreferencePersistedDOMEventSetting("submit"));
        this.addSetting(new PreferencePersistedDOMEventSetting("reset"));
        this.addSetting(new PreferencePersistedDOMEventSetting("focus"));
        this.addSetting(new PreferencePersistedDOMEventSetting("blur"));
        this.addSetting(new DOMMutationEventSetting("DOMNodeInserted"));
        this.addSetting(new DOMMutationEventSetting("DOMNodeRemoved"));
        this.addSetting(new DOMMutationEventSetting("DOMAttrModified"));
    }

    protected void addSetting(IDOMEventSetting setting) {
        this.settings.add(setting);
        this.eventTypeSettingsMap.put(setting.getEventType(), setting);
    }

    public IDOMEventSetting getSetting(String eventType) {
        return (IDOMEventSetting)this.eventTypeSettingsMap.get(eventType);
    }

    public IDOMEventSetting[] getSettings() {
        IDOMEventSetting[] settingsArray = new IDOMEventSetting[this.settings.size()];
        return this.settings.toArray(settingsArray);
    }

    public String[] getSupportedEventTypes() {
        String[] supportedEventTypes = new String[this.settings.size()];
        return this.eventTypeSettingsMap.keySet().toArray(supportedEventTypes);
    }
}

