/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.internal.browser.support;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.atf.mozilla.ide.ui.internal.browser.support.BrowserListener;
import org.eclipse.atf.mozilla.ide.ui.internal.browser.support.InternalWebBrowser;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWorkbenchBrowserSupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.ExternalBrowserInstance;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.InternalBrowserEditorInstance;
import org.eclipse.ui.internal.browser.InternalBrowserViewInstance;
import org.eclipse.ui.internal.browser.SystemBrowserDescriptor;
import org.eclipse.ui.internal.browser.SystemBrowserInstance;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class WorkbenchBrowserSupport
extends AbstractWorkbenchBrowserSupport {
    private static final String DEFAULT_BROWSER_ID_BASE = "org.eclipse.ui.defaultBrowser";
    private static final String HELP_BROWSER_ID = "org.eclipse.help.ui";
    private static Hashtable<String, IWebBrowser> browsers = new Hashtable();
    private static Set<BrowserListener> listeners = new HashSet<BrowserListener>();
    private static WorkbenchBrowserSupport instance;

    public static WorkbenchBrowserSupport getInstance() {
        if (instance == null) {
            new WorkbenchBrowserSupport();
        }
        return instance;
    }

    @Deprecated
    public WorkbenchBrowserSupport() {
        if (instance == null) {
            instance = this;
        }
    }

    void registerBrowser(IWebBrowser browser) {
        if (!(browser instanceof InternalWebBrowser)) {
            return;
        }
        browsers.put(browser.getId(), browser);
    }

    void unregisterBrowser(IWebBrowser browser) {
        browsers.remove(browser.getId());
        this.fireBrowserClosed(browser);
    }

    IWebBrowser findBrowser(String id) {
        return browsers.get(id);
    }

    protected IWebBrowser doCreateBrowser(int style, String browserId, String name, String tooltip) throws PartInitException {
        boolean isHelpEditor;
        if ((style & 0x80) == 0 && WebBrowserPreference.getBrowserChoice() == 0) {
            return new InternalWebBrowser(this, browserId);
        }
        Object webBrowser = null;
        boolean bl = isHelpEditor = (style & 0x20) != 0 && HELP_BROWSER_ID.equals(browserId);
        if ((style & 0x80) != 0 || WebBrowserPreference.getBrowserChoice() != 0 && !isHelpEditor || !WebBrowserUtil.canUseInternalWebBrowser()) {
            IBrowserDescriptor ewb = BrowserManager.getInstance().getCurrentWebBrowser();
            if (ewb == null) {
                throw new PartInitException("Error No Browser detected");
            }
            if (ewb instanceof SystemBrowserDescriptor) {
                webBrowser = new SystemBrowserInstance(browserId);
            } else {
                IBrowserExt ext = null;
                if (ewb != null) {
                    ext = WebBrowserUIPlugin.findBrowsers((String)this.getLocation(ewb));
                }
                if (ext != null) {
                    webBrowser = ext.createBrowser(browserId, this.getLocation(ewb), ewb.getParameters());
                }
                if (webBrowser == null) {
                    webBrowser = new ExternalBrowserInstance(browserId, ewb);
                }
            }
        } else {
            webBrowser = (style & 0x40) != 0 ? new InternalBrowserViewInstance(browserId, style, name, tooltip) : new InternalBrowserEditorInstance(browserId, style, name, tooltip);
        }
        return webBrowser;
    }

    private String getLocation(IBrowserDescriptor ewb) {
        String location = ewb.getLocation();
        if (location != null) {
            File browser = new File(location);
            if ((browser = this.adjustFor64BitWindows(browser)).exists()) {
                return browser.toString();
            }
        }
        return location;
    }

    private File adjustFor64BitWindows(File browser) {
        File IE_x86;
        if ("win32".equals(Platform.getOS()) && browser.toString().toLowerCase().endsWith("\\program files\\internet explorer\\iexplore.exe") && (IE_x86 = new File(browser.getParentFile().getParentFile().getParentFile(), "Program Files (x86)\\Internet Explorer\\iexplore.exe")).exists()) {
            return IE_x86;
        }
        return browser;
    }

    public IWebBrowser createBrowser(int style, String browserId, String name, String tooltip) throws PartInitException {
        String id = browserId == null ? this.getDefaultId() : browserId;
        IWebBrowser browser = this.findBrowser(id);
        if (browser != null) {
            return browser;
        }
        browser = this.doCreateBrowser(style, id, name, tooltip);
        this.registerBrowser(browser);
        return browser;
    }

    public IWebBrowser createBrowser(String browserId) throws PartInitException {
        return this.createBrowser(32, browserId, null, null);
    }

    private String getDefaultId() {
        String id = null;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            id = DEFAULT_BROWSER_ID_BASE + i;
            if (browsers.get(id) == null) break;
            ++i;
        }
        return id;
    }

    public boolean isInternalWebBrowserAvailable() {
        return true;
    }

    public IWebBrowser getBrowser(String key) {
        return browsers.get(key);
    }

    public void addBrowserListener(BrowserListener listener) {
        listeners.add(listener);
    }

    public void removeBrowserListener(BrowserListener listener) {
        listeners.remove(listener);
    }

    void fireBrowserCreated(IWebBrowser browser) {
        BrowserListener[] listeners = WorkbenchBrowserSupport.listeners.toArray(new BrowserListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].browserCreated(browser);
            ++i;
        }
    }

    private void fireBrowserClosed(IWebBrowser browser) {
        BrowserListener[] listeners = WorkbenchBrowserSupport.listeners.toArray(new BrowserListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].browserClosed(browser);
            ++i;
        }
    }
}

