/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.BaseNetworkCall;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.NetworkEventsPublisher;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.NetworkFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.mozilla.interfaces.nsIChannel;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsILoadGroup;
import org.mozilla.interfaces.nsIObserver;
import org.mozilla.interfaces.nsIObserverService;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIRequestObserver;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.interfaces.nsIXMLHttpRequest;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class MozNetworkMonitorAdapter
implements nsIObserver,
nsIWebProgressListener {
    protected static final String HTTP_ON_MODIFY_REQUEST_TOPIC = "http-on-modify-request";
    protected static final String HTTP_ON_EXAMINE_RESPONSE_TOPIC = "http-on-examine-response";
    protected Map<String, BaseNetworkCall> ongoingCalls = new HashMap<String, BaseNetworkCall>();
    private Map<String, List> ongoingCallsEvents = new HashMap<String, List>();
    protected IWebBrowser browserContext = null;
    private NetworkEventsPublisher eventsPublisher;
    private boolean connected = false;

    public MozNetworkMonitorAdapter(IWebBrowser browserContext) {
        this.browserContext = browserContext;
        this.eventsPublisher = new NetworkEventsPublisher(browserContext);
    }

    public void connect() {
        if (!this.connected) {
            nsIWebBrowser mozBrowser = (nsIWebBrowser)this.browserContext.getAdapter(nsIWebBrowser.class);
            mozBrowser.addWebBrowserListener((nsISupports)this, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
            nsIObserverService observerService = (nsIObserverService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/observer-service;1", "{d07f5192-e3d1-11d2-8acd-00105a1b8860}");
            observerService.addObserver((nsIObserver)this, HTTP_ON_MODIFY_REQUEST_TOPIC, false);
            observerService.addObserver((nsIObserver)this, HTTP_ON_EXAMINE_RESPONSE_TOPIC, false);
            this.connected = true;
        }
    }

    public void disconnect() {
        if (this.connected) {
            nsIWebBrowser mozBrowser = (nsIWebBrowser)this.browserContext.getAdapter(nsIWebBrowser.class);
            Browser swtBrowser = (Browser)this.browserContext.getAdapter(Browser.class);
            if (swtBrowser != null && !swtBrowser.isDisposed()) {
                mozBrowser.removeWebBrowserListener((nsISupports)this, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
                nsIObserverService observerService = (nsIObserverService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/observer-service;1", "{d07f5192-e3d1-11d2-8acd-00105a1b8860}");
                observerService.removeObserver((nsIObserver)this, HTTP_ON_MODIFY_REQUEST_TOPIC);
                observerService.removeObserver((nsIObserver)this, HTTP_ON_EXAMINE_RESPONSE_TOPIC);
            }
            this.connected = false;
        }
    }

    public void observe(nsISupports subject, String topic, String data) {
        block10: {
            try {
                nsIDOMWindow contextWindow;
                nsIDOMWindow requestOwnerWindow;
                nsIRequest request = (nsIRequest)subject.queryInterface("{ef6bfbd2-fd46-48d8-96b7-9f8f0fd387fe}");
                nsIWebProgress webProgress = null;
                try {
                    nsIRequestObserver observer;
                    nsILoadGroup loadGroup = request.getLoadGroup();
                    if (loadGroup != null && (observer = loadGroup.getGroupObserver()) != null) {
                        webProgress = (nsIWebProgress)observer.queryInterface("{570f39d0-efd0-11d3-b093-00a024ffc08c}");
                    }
                }
                catch (Exception exception) {}
                if (webProgress == null) {
                    nsIChannel channel = (nsIChannel)request.queryInterface("{c63a055a-a676-4e71-bf3c-6cfa11082018}");
                    webProgress = (nsIWebProgress)channel.getNotificationCallbacks().getInterface("{570f39d0-efd0-11d3-b093-00a024ffc08c}");
                }
                if ((requestOwnerWindow = webProgress.getDOMWindow().getTop()) != (contextWindow = (nsIDOMWindow)this.browserContext.getAdapter(nsIDOMWindow.class))) {
                    return;
                }
                if (HTTP_ON_MODIFY_REQUEST_TOPIC.equals(topic)) {
                    this.inc(request.getName(), "observe");
                    this.observeRequest(request);
                    break block10;
                }
                if (!HTTP_ON_EXAMINE_RESPONSE_TOPIC.equals(topic)) break block10;
                try {
                    this.observeResponse(request);
                }
                catch (Exception exception) {}
                this.dec(request.getName(), "observe", false);
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
    }

    protected void observeRequest(nsIRequest request) {
        if ((request.getLoadFlags() & 1L) != 0L) {
            try {
                nsIHttpChannel httpChannel = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                nsIInterfaceRequestor intReq = httpChannel.getNotificationCallbacks();
                nsIXMLHttpRequest xhr = (nsIXMLHttpRequest)intReq.getInterface("{ad78bf21-2227-447e-8ed5-824a017c265f}");
                this.handleXHRRequest(xhr, request.getName());
                return;
            }
            catch (XPCOMException xPCOMException) {}
        }
        try {
            nsIHttpChannel httpRequest = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
            BaseNetworkCall call = new BaseNetworkCall();
            NetworkFactory.captureRequest(call, httpRequest, false);
            this.ongoingCalls.put(request.getName(), call);
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
        }
    }

    protected void observeResponse(nsIRequest request) {
        BaseNetworkCall call;
        if ((request.getLoadFlags() & 1L) != 0L) {
            try {
                nsIHttpChannel httpChannel = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                nsIInterfaceRequestor intReq = httpChannel.getNotificationCallbacks();
                intReq.getInterface("{ad78bf21-2227-447e-8ed5-824a017c265f}");
                return;
            }
            catch (XPCOMException xPCOMException) {}
        }
        if ((call = this.ongoingCalls.get(request.getName())) != null) {
            nsIHttpChannel httpRequest = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
            NetworkFactory.captureResponse(call, httpRequest, 2152398854L);
        }
    }

    protected void handleXHRRequest(nsIXMLHttpRequest xhr, String name) {
        try {
            BaseNetworkCall call = new BaseNetworkCall();
            nsIHttpChannel httpChannel = (nsIHttpChannel)xhr.getChannel().queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
            NetworkFactory.captureRequest(call, httpChannel, true);
            new XHRHandler(xhr, name);
            this.ongoingCalls.put(name, call);
            this.inc(name, "xhr");
        }
        catch (Exception e) {
            MozIDEUIPlugin.log((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", "Failed handleXHRRequest: " + e.getMessage(), (Throwable)e));
        }
    }

    protected void handleXHRResponse(nsIXMLHttpRequest xhr, boolean error, String name) {
        BaseNetworkCall call = this.ongoingCalls.get(name);
        NetworkFactory.captureResponse(call, xhr, error);
        this.eventsPublisher.postNetworkEvent("org.eclipse.atf.mozilla.ide.network", call.getStartTime(), call.getEndTime(), call);
        this.dec(name, "xhr", true);
    }

    public void onStateChange(nsIWebProgress webProgress, nsIRequest request, long stateFlags, long status) {
        if ((stateFlags & 0x10000L) == 0L) {
            return;
        }
        if (request.getName().startsWith("about:")) {
            return;
        }
        if ((stateFlags & 1L) != 0L) {
            this.inc(request.getName(), "onStateChange");
        } else if ((stateFlags & 0x10L) != 0L) {
            this.handleStopRequest(webProgress, request, stateFlags, status);
            this.dec(request.getName(), "onStateChange", true);
        }
    }

    protected void handleStartRequest(nsIWebProgress webProgress, nsIRequest request, long stateFlags, long status) {
        BaseNetworkCall call = new BaseNetworkCall();
        try {
            nsIHttpChannel httpRequest = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
            NetworkFactory.captureRequest(call, httpRequest, false);
        }
        catch (Exception exception) {}
        this.ongoingCalls.put(request.getName(), call);
    }

    protected void handleStopRequest(nsIWebProgress webProgress, nsIRequest request, long stateFlags, long status) {
        BaseNetworkCall call = this.ongoingCalls.get(request.getName());
        if (call == null) {
            return;
        }
        try {
            nsIHttpChannel httpRequest = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
            NetworkFactory.captureResponse(call, httpRequest, -2L);
        }
        catch (XPCOMException xPCOMException) {}
    }

    public void onLocationChange(nsIWebProgress webProgress, nsIRequest request, nsIURI location) {
    }

    public void onProgressChange(nsIWebProgress webProgress, nsIRequest request, int curSelfProgress, int maxSelfProgress, int curTotalProgress, int maxTotalProgress) {
    }

    public void onSecurityChange(nsIWebProgress webProgress, nsIRequest request, long state) {
    }

    public void onStatusChange(nsIWebProgress webProgress, nsIRequest request, long status, String message) {
        BaseNetworkCall call = this.ongoingCalls.get(request.getName());
        if (call != null) {
            call.addStatusChange(status, System.currentTimeMillis());
        }
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    private void inc(String key, String token) {
        ArrayList<String> r = this.ongoingCallsEvents.get(key);
        if (r == null) {
            r = new ArrayList<String>();
            this.ongoingCallsEvents.put(key, r);
        }
        r.add(token);
    }

    private void dec(String key, String token, boolean removeItem) {
        List i = this.ongoingCallsEvents.get(key);
        if (i == null) {
            throw new IllegalStateException();
        }
        boolean result = i.remove(token);
        if (i.size() <= 1 && removeItem) {
            this.ongoingCallsEvents.remove(key);
            BaseNetworkCall call = this.ongoingCalls.remove(key);
            if (call != null) {
                this.eventsPublisher.postNetworkEvent("org.eclipse.atf.mozilla.ide.network", call.getStartTime(), call.getEndTime(), call);
            }
        }
    }

    protected class XHRHandler
    implements nsIDOMEventListener {
        protected nsIXMLHttpRequest xhr;
        private String name;
        protected static final int COMPLETE_READYSTATE = 4;
        protected static final int OK_STATUS = 200;
        protected static final String LOAD_TYPE = "load";
        protected static final String ERROR_TYPE = "error";
        protected static final String READYSTATE_TYPE = "readystatechange";

        public XHRHandler(nsIXMLHttpRequest xhr, String name) {
            this.xhr = xhr;
            this.name = name;
            nsIDOMEventTarget eventListener = (nsIDOMEventTarget)xhr.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            eventListener.addEventListener(ERROR_TYPE, (nsIDOMEventListener)this, false);
            eventListener.addEventListener(LOAD_TYPE, (nsIDOMEventListener)this, false);
            eventListener.addEventListener(READYSTATE_TYPE, (nsIDOMEventListener)this, false);
        }

        public void handleEvent(nsIDOMEvent event) {
            if (this.xhr == null) {
                return;
            }
            if (this.xhr.getReadyState() != 4) {
                return;
            }
            try {
                MozNetworkMonitorAdapter.this.handleXHRResponse(this.xhr, ERROR_TYPE.equals(event.getType()), this.name);
            }
            finally {
                nsIDOMEventTarget eventListener = (nsIDOMEventTarget)this.xhr.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
                eventListener.removeEventListener(ERROR_TYPE, (nsIDOMEventListener)this, false);
                eventListener.removeEventListener(READYSTATE_TYPE, (nsIDOMEventListener)this, false);
                this.xhr = null;
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    }
}

