/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import org.eclipse.atf.mozilla.ide.network.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class NetworkCallSorter
extends ViewerSorter {
    public static final int STATE = 1;
    public static final int URL = 2;
    public static final int METHOD = 3;
    public static final int START_TIME = 4;
    public static final int STOP_TIME = 5;
    public static final int ELAPSED_TIME = 6;
    private int criteria;
    private boolean ascending = true;

    public NetworkCallSorter(int criteria) {
        this.criteria = criteria;
    }

    public NetworkCallSorter(int criteria, boolean ascending) {
        this.criteria = criteria;
        this.ascending = ascending;
    }

    public int getColumnCriteria() {
        return this.criteria;
    }

    public void setColumnCriteria(int criteria) {
        this.criteria = criteria;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        INetworkCall call1 = (INetworkCall)o1;
        INetworkCall call2 = (INetworkCall)o2;
        switch (this.criteria) {
            case 1: {
                return this.compareState(call1, call2);
            }
            case 2: {
                return this.compareUrl(call1, call2);
            }
            case 3: {
                return this.compareMethod(call1, call2);
            }
            case 4: {
                return this.compareStartTime(call1, call2);
            }
            case 5: {
                return this.compareStopTime(call1, call2);
            }
            case 6: {
                return this.compareElapsedTime(call1, call2);
            }
        }
        return 0;
    }

    private int compareState(INetworkCall call1, INetworkCall call2) {
        int compare = this.getComparator().compare(call1.getState(), call2.getState());
        if (this.ascending) {
            return compare;
        }
        return -compare;
    }

    private int compareUrl(INetworkCall call1, INetworkCall call2) {
        int compare = this.getComparator().compare(call1.getRequest().getURL(), call2.getRequest().getURL());
        if (this.ascending) {
            return compare;
        }
        return -compare;
    }

    private int compareMethod(INetworkCall call1, INetworkCall call2) {
        String method1 = "";
        if (call1 instanceof IHTTPRequest) {
            method1 = ((IHTTPRequest)call1).getMethod();
        }
        String method2 = "";
        if (call1 instanceof IHTTPRequest) {
            method2 = ((IHTTPRequest)call2).getMethod();
        }
        int compare = this.getComparator().compare(method1, method2);
        if (this.ascending) {
            return compare;
        }
        return -compare;
    }

    private int compareStartTime(INetworkCall call1, INetworkCall call2) {
        long diff = call1.getStartTime() - call2.getStartTime();
        if (this.ascending) {
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }
        return diff > 0L ? -1 : (diff < 0L ? 1 : 0);
    }

    private int compareStopTime(INetworkCall call1, INetworkCall call2) {
        long diff = call1.getEndTime() - call2.getEndTime();
        if (this.ascending) {
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }
        return diff > 0L ? -1 : (diff < 0L ? 1 : 0);
    }

    private int compareElapsedTime(INetworkCall call1, INetworkCall call2) {
        int diff = call1.getTotalTime() - call2.getTotalTime();
        if (this.ascending) {
            return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
        }
        return diff > 0 ? -1 : (diff < 0 ? 1 : 0);
    }
}

