/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.atf.mozilla.ide.events.ITimedEvent;
import org.eclipse.atf.mozilla.ide.network.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.atf.mozilla.ide.network.IRequest;
import org.eclipse.atf.mozilla.ide.network.IStatusChange;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class NetworkMonitorPageFilters {
    public static final String VIEW_POINT = "org.eclipse.atf.mozilla.ide.ui.filter";
    public static final String FILTER_NODE = "filter";
    public static final String CLASS_ATTR = "class";
    public static final String ICON_ATTR = "icon";
    public static final String TOOLTIP_ATTR = "tooltip";
    protected Action clearAction = null;
    protected Action scrollLockAction = null;
    protected Action filterXHR = null;
    protected Action filterHTTP = null;
    private boolean scrollLock = false;
    protected ViewerFilter xhrFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IStatusChange) {
                element = ((IStatusChange)element).getCall();
            }
            if (element instanceof ITimedEvent) {
                element = ((ITimedEvent)element).getData();
            }
            if (!(element instanceof INetworkCall)) {
                return true;
            }
            INetworkCall call = (INetworkCall)element;
            IRequest req = call.getRequest();
            if (req instanceof IHTTPRequest) {
                return ((IHTTPRequest)req).isXHR();
            }
            return false;
        }
    };
    protected ViewerFilter httpFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IStatusChange) {
                element = ((IStatusChange)element).getCall();
            }
            if (element instanceof ITimedEvent) {
                element = ((ITimedEvent)element).getData();
            }
            if (!(element instanceof INetworkCall)) {
                return true;
            }
            INetworkCall call = (INetworkCall)element;
            IRequest req = call.getRequest();
            if (req instanceof IHTTPRequest) {
                return !((IHTTPRequest)req).isXHR();
            }
            return false;
        }
    };
    protected List filters = new ArrayList();
    protected List actions = new ArrayList();
    private Set enabledFilters = new HashSet();

    public NetworkMonitorPageFilters(IToolBarManager toolBarManager) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(VIEW_POINT);
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                try {
                    if (ce[j].getName().equals(FILTER_NODE)) {
                        String filter = ce[j].getAttribute(CLASS_ATTR);
                        String icon = ce[j].getAttribute(ICON_ATTR);
                        String tooltip = ce[j].getAttribute(TOOLTIP_ATTR);
                        if (filter != null && icon != null && tooltip != null) {
                            ViewerFilter filterObj = (ViewerFilter)ce[j].createExecutableExtension(CLASS_ATTR);
                            Action action = new Action(null, 2, filterObj){
                                private ViewerFilter filter;
                                {
                                    this.filter = viewerFilter;
                                }

                                public void run() {
                                    if (this.isChecked()) {
                                        NetworkMonitorPageFilters.this.disableOtherActions((IAction)this);
                                        NetworkMonitorPageFilters.this.enabledFilters.removeAll(NetworkMonitorPageFilters.this.filters);
                                        NetworkMonitorPageFilters.this.enabledFilters.add(this.filter);
                                    } else {
                                        NetworkMonitorPageFilters.this.enabledFilters.remove(this.filter);
                                    }
                                    NetworkMonitorPageFilters.this.updateFilters();
                                }
                            };
                            action.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor(icon));
                            action.setToolTipText(tooltip);
                            this.filters.add(filterObj);
                            this.actions.add(action);
                            toolBarManager.add((IAction)action);
                        }
                    }
                }
                catch (Exception exception) {}
                ++j;
            }
            ++i;
        }
        this.filterXHR = new Action(null, 2){

            public void run() {
                if (this.isChecked()) {
                    NetworkMonitorPageFilters.this.filterHTTP.setChecked(false);
                    NetworkMonitorPageFilters.this.enabledFilters.remove(NetworkMonitorPageFilters.this.httpFilter);
                    NetworkMonitorPageFilters.this.enabledFilters.add(NetworkMonitorPageFilters.this.xhrFilter);
                } else {
                    NetworkMonitorPageFilters.this.enabledFilters.remove(NetworkMonitorPageFilters.this.xhrFilter);
                }
                NetworkMonitorPageFilters.this.updateFilters();
            }
        };
        this.filterXHR.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("FILTERXHR_ID"));
        this.filterXHR.setToolTipText("Show XHR only");
        this.filterHTTP = new Action(null, 2){

            public void run() {
                if (this.isChecked()) {
                    NetworkMonitorPageFilters.this.filterXHR.setChecked(false);
                    NetworkMonitorPageFilters.this.enabledFilters.remove(NetworkMonitorPageFilters.this.xhrFilter);
                    NetworkMonitorPageFilters.this.enabledFilters.add(NetworkMonitorPageFilters.this.httpFilter);
                } else {
                    NetworkMonitorPageFilters.this.enabledFilters.remove(NetworkMonitorPageFilters.this.httpFilter);
                }
                NetworkMonitorPageFilters.this.updateFilters();
            }
        };
        this.filterHTTP.setToolTipText("Show HTTP only");
        this.filterHTTP.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("FILTERHTTP_ID"));
        this.scrollLockAction = new Action(null, 2){

            public void run() {
                NetworkMonitorPageFilters.this.scrollLock = this.isChecked();
            }
        };
        this.scrollLockAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/scrolllock.gif"));
        this.scrollLockAction.setToolTipText("Lock/Unlock the scroll of the content pane");
        this.scrollLockAction.setChecked(false);
        this.clearAction = new Action(null, 1){

            public void run() {
                NetworkMonitorPageFilters.this.clear();
            }
        };
        this.clearAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("CLEAR_IMG_ID"));
        this.clearAction.setToolTipText("Clear the call list");
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.filterXHR);
        toolBarManager.add((IAction)this.filterHTTP);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.scrollLockAction);
        toolBarManager.add((IAction)this.clearAction);
    }

    private void disableOtherActions(IAction action) {
        int i = 0;
        while (i < this.actions.size()) {
            if (!this.actions.get(i).equals(action)) {
                ((IAction)this.actions.get(i)).setChecked(false);
            }
            ++i;
        }
    }

    private void updateFilters() {
        ViewerFilter[] newFilters = this.enabledFilters.toArray(new ViewerFilter[this.enabledFilters.size()]);
        this.setFilters(newFilters);
    }

    public boolean getScrollLock() {
        return this.scrollLock;
    }

    protected abstract void setFilters(ViewerFilter[] var1);

    protected abstract void clear();
}

