/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.ArrayList;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.ITimedEvent;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.atf.mozilla.ide.ui.netmon.EventRecorder;
import org.eclipse.atf.mozilla.ide.ui.netmon.NetworkCallLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.netmon.NetworkCallSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class NetworkMonitorTable {
    protected static final String STATE_COL = "state";
    protected static final String URL_COL = "url";
    protected static final String METHOD_COL = "method";
    protected static final String START_COL = "start";
    protected static final String STOP_COL = "stop";
    protected static final String ELAPSED_COL = "elapsed";
    protected String[] columnNames = new String[]{"state", "url", "method", "start", "stop", "elapsed"};
    protected TableViewer callsViewer = null;
    protected Table table = null;
    private EventRecorder callList;

    public static INetworkCall[] eventsToCalls(IApplicationEvent[] events) {
        ArrayList<INetworkCall> filtered = new ArrayList<INetworkCall>();
        int i = 0;
        while (i < events.length) {
            INetworkCall event = NetworkMonitorTable.eventToCall(events[i]);
            if (event != null) {
                filtered.add(event);
            }
            ++i;
        }
        return filtered.toArray(new INetworkCall[filtered.size()]);
    }

    public static INetworkCall eventToCall(IApplicationEvent event) {
        ITimedEvent tevent;
        if (event instanceof ITimedEvent && (tevent = (ITimedEvent)event).getData() instanceof INetworkCall) {
            return (INetworkCall)tevent.getData();
        }
        return null;
    }

    public NetworkMonitorTable(SashForm displayArea) {
        this.createTable(displayArea);
        this.callsViewer.setLabelProvider((IBaseLabelProvider)new NetworkCallLabelProvider());
        this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(4));
        this.callsViewer.setContentProvider((IContentProvider)new NetworkCallListContentProvider());
    }

    protected void createTable(SashForm displayArea) {
        Table newTable;
        int style = 68356;
        this.table = newTable = new Table((Composite)displayArea, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        newTable.setLayoutData((Object)gridData);
        newTable.setLinesVisible(true);
        newTable.setHeaderVisible(true);
        this.createTableViewer(newTable);
        TableColumn column = new TableColumn(newTable, 16384, 0);
        column.setText("");
        column.setWidth(25);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 1) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(1, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(1));
                }
            }
        });
        column = new TableColumn(newTable, 16384, 1);
        column.setText("URL");
        column.setWidth(300);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 2) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(2, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(2));
                }
            }
        });
        column = new TableColumn(newTable, 16384, 2);
        column.setText("Method");
        column.setWidth(75);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 3) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(3, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(3));
                }
            }
        });
        column = new TableColumn(newTable, 16384, 3);
        column.setText("Start Time");
        column.setWidth(175);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 4) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(4, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(4));
                }
            }
        });
        column = new TableColumn(newTable, 16384, 4);
        column.setText("Stop Time");
        column.setWidth(175);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 5) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(5, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(5));
                }
            }
        });
        column = new TableColumn(newTable, 16384, 5);
        column.setText("Elapsed Time");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 6) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(6, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(6));
                }
            }
        });
        column = new TableColumn(newTable, 16384, 6);
        column.setText("Status Code");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkCallSorter sorter = (NetworkCallSorter)NetworkMonitorTable.this.callsViewer.getSorter();
                if (sorter != null && sorter.getColumnCriteria() == 1) {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(1, !sorter.isAscending()));
                } else {
                    NetworkMonitorTable.this.callsViewer.setSorter((ViewerSorter)new NetworkCallSorter(1));
                }
            }
        });
    }

    protected void createTableViewer(Table table) {
        this.callsViewer = new TableViewer(table);
        this.callsViewer.setUseHashlookup(true);
        this.callsViewer.setColumnProperties(this.columnNames);
    }

    public void setFilters(ViewerFilter[] filters) {
        this.callsViewer.setFilters(filters);
    }

    public Table getControl() {
        return this.table;
    }

    public TableViewer getViewer() {
        return this.callsViewer;
    }

    public void setCallList(EventRecorder callList) {
        this.callList = callList;
        this.callsViewer.setInput((Object)callList);
    }

    public void notifyCallAdded(final INetworkCall call) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                NetworkMonitorTable.this.callsViewer.add((Object)call);
            }
        });
    }

    public void notifyCallUpdated(final INetworkCall call) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                NetworkMonitorTable.this.callsViewer.update((Object)call, null);
            }
        });
    }

    private class NetworkCallListContentProvider
    implements IStructuredContentProvider {
        private NetworkCallListContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IApplicationEvent[] result = NetworkMonitorTable.this.callList.getAll();
            return NetworkMonitorTable.eventsToCalls(result);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

