/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.util;

import java.net.URL;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceDisplayUtil {
    public IEditorInput getEditorInput(Object element) {
        Object editorInput = null;
        if (element instanceof IFile) {
            editorInput = new FileEditorInput((IFile)element);
        } else if (element instanceof IStorage) {
            editorInput = new StorageEditorInput((IStorage)element);
        }
        return editorInput;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorDescriptor descriptor;
        block3: {
            try {
                descriptor = IDE.getEditorDescriptor((String)input.getName());
                if (!"org.eclipse.atf.mozilla.ide.ui.MozBrowserEditor".equals(descriptor.getId()) && !"org.eclipse.ui.systemExternalEditor".equals(descriptor.getId())) break block3;
                return "org.eclipse.ui.DefaultTextEditor";
            }
            catch (PartInitException partInitException) {
                return null;
            }
        }
        return descriptor.getId();
    }

    public void openInEditor(IEditorInput input, int lineNumber) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.openInEditor(page, input, lineNumber);
    }

    public void openInEditor(IWorkbenchPage page, IEditorInput input, int lineNumber) throws PartInitException {
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)this.getEditorId(input, null), (boolean)true);
        if (lineNumber > 0) {
            ITextEditor textEditor = null;
            textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                this.revealLineInEditor(textEditor, lineNumber);
            }
        }
    }

    private void revealLineInEditor(ITextEditor editor, int lineNumber) {
        IRegion region;
        block9: {
            --lineNumber;
            region = null;
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return;
            }
            try {
                try {
                    IDocument document = provider.getDocument((Object)input);
                    if (document != null) {
                        region = document.getLineInformation(lineNumber);
                    }
                }
                catch (BadLocationException badLocationException) {
                    provider.disconnect((Object)input);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
        }
        if (region != null) {
            editor.selectAndReveal(region.getOffset(), 0);
        }
    }

    protected class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput {
        private IStorage _storage;

        public StorageEditorInput(IStorage storage) {
            this._storage = storage;
        }

        public IStorage getStorage() throws CoreException {
            return this._storage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this._storage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            Object url = this._storage.getAdapter(URL.class);
            return url == null ? this.getName() : ((URL)url).toExternalForm();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StorageEditorInput) {
                try {
                    return ((StorageEditorInput)((Object)obj)).getStorage().equals(this._storage);
                }
                catch (CoreException ce) {
                    MozIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", "Error getting storage", (Throwable)ce));
                }
            }
            return false;
        }

        public int hashCode() {
            return this._storage.hashCode();
        }

        public Object getAdapter(Class adapter) {
            try {
                if (IStorage.class.equals((Object)adapter)) {
                    return this.getStorage();
                }
                if (IResource.class.equals((Object)adapter)) {
                    return super.getAdapter(adapter);
                }
            }
            catch (CoreException coreException) {}
            return super.getAdapter(adapter);
        }
    }
}

