/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class JSLogicalStructureTypeDelegate
implements ILogicalStructureTypeDelegate {
    public boolean providesLogicalStructure(IValue value) {
        return false;
    }

    public IValue getLogicalStructure(IValue value) throws CoreException {
        final IValue v = value;
        return new IIndexedValue(){
            private boolean _initialized = false;
            private IVariable[] _variables = null;

            public String getReferenceTypeName() throws DebugException {
                return v.getReferenceTypeName();
            }

            public String getValueString() throws DebugException {
                return v.getValueString();
            }

            public boolean isAllocated() throws DebugException {
                return v.isAllocated();
            }

            public IVariable[] getVariables() throws DebugException {
                if (!this._initialized) {
                    IVariable[] variables = v.getVariables();
                    int len = variables == null ? 0 : variables.length;
                    IVariable subviews = null;
                    int i = 0;
                    while (i < len) {
                        if ("subviews".equals(variables[i].getName())) {
                            subviews = variables[i];
                            break;
                        }
                        ++i;
                    }
                    this._variables = subviews == null ? new IVariable[]{} : this.sort(subviews.getValue().getVariables());
                    this._initialized = true;
                }
                return this._variables;
            }

            private IVariable[] sort(IVariable[] vars) throws DebugException {
                IVariable[] sortedVars = new IVariable[vars.length];
                int i = 0;
                while (i < vars.length) {
                    int index = Integer.parseInt(vars[i].getName());
                    sortedVars[index] = vars[i];
                    ++i;
                }
                return sortedVars;
            }

            public boolean hasVariables() throws DebugException {
                boolean result = v.hasVariables();
                if (result) {
                    IVariable[] variables = this.getVariables();
                    result = variables != null && variables.length > 0;
                }
                return result;
            }

            public String getModelIdentifier() {
                return v.getModelIdentifier();
            }

            public IDebugTarget getDebugTarget() {
                return v.getDebugTarget();
            }

            public ILaunch getLaunch() {
                return v.getLaunch();
            }

            public Object getAdapter(Class adapter) {
                if (adapter.equals(IIndexedValue.class)) {
                    return this;
                }
                return v.getAdapter(adapter);
            }

            public IVariable getVariable(int offset) throws DebugException {
                return this.getVariables()[offset];
            }

            public IVariable[] getVariables(int offset, int length) throws DebugException {
                IVariable[] vars = new IVariable[length];
                System.arraycopy(this.getVariables(), offset, vars, 0, length);
                return vars;
            }

            public int getSize() throws DebugException {
                return this.getVariables().length;
            }

            public int getInitialOffset() {
                return 0;
            }
        };
    }
}

