/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.internal.model;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.XPCOMThreadProxy;
import org.eclipse.atf.mozilla.ide.debug.INestedEventLoop;
import org.eclipse.atf.mozilla.ide.debug.JSDebugCoreMessages;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugThread;
import org.eclipse.atf.mozilla.ide.debug.model.JSBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.model.JSDebuggerKeywordBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.model.JSErrorBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.model.JSExceptionBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.atf.mozilla.ide.debug.model.JSStartupBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.mozilla.interfaces.jsdIDebuggerService;
import org.mozilla.interfaces.jsdIScript;
import org.mozilla.interfaces.jsdIScriptEnumerator;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class JSDebugTarget
extends JSDebugElement
implements IDebugTarget,
IDebugEventSetListener,
IBreakpointListener,
IBreakpointManagerListener {
    private static final long NS_ERROR_NOT_AVAILABLE = 2147746065L;
    private ILaunch _launch;
    private IProcess _process;
    private JSDebugThread[] _threads = new JSDebugThread[0];
    private URL _appURL;
    private boolean _terminated = false;
    private boolean _connected = false;
    private String _errorString = null;
    private ILog _logger = null;
    private jsdIDebuggerService _debuggerService;
    private INestedEventLoop _eventLoop;
    private IXPCOMThreadProxyHelper _proxyHelper;
    private IBreakpointManager _breakpointManager;
    private BreakpointsChangedListener _fBreakpointsChangedListener;
    private nsIWebProgressListener webProgressListener = new WebProgressListener();

    public JSDebugTarget(ILaunch launch, URL appURL, INestedEventLoop eventLoop, IXPCOMThreadProxyHelper proxyHelper) throws DebugException {
        super(null);
        this._launch = launch;
        this._appURL = appURL;
        JSDebugThread thread = new JSDebugThread(this);
        this._threads = new JSDebugThread[]{thread};
        this._proxyHelper = proxyHelper;
        this._debuggerService = (jsdIDebuggerService)XPCOMThreadProxy.createProxy((nsISupports)MozillaDebugPlugin.createDebuggerService(), (IXPCOMThreadProxyHelper)proxyHelper);
        this._eventLoop = eventLoop;
        this.setupDebuggerHooks(thread);
        this._debuggerService.setFlags(1L);
        this.handleConnectionStarted();
        this._breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this._breakpointManager.addBreakpointListener((IBreakpointListener)this);
        this._breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this._fBreakpointsChangedListener = new BreakpointsChangedListener();
        this._breakpointManager.addBreakpointListener((IBreakpointsListener)this._fBreakpointsChangedListener);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    protected void setupDebuggerHooks(JSDebugThread thread) {
        thread.setScriptHook();
        thread.setErrorHook();
        thread.setBreakpointHook();
        thread.setFunctionHook();
        thread.setTopLevelHook();
        thread.setDebugHook();
        thread.setThrowHook();
    }

    protected void removeDebuggerHooks() {
        MozillaDebugPlugin.debug("JSDebugTarget.removeDebuggerHooks");
        this.unsetTopLevelHook();
        this.unsetFunctionHook();
        this.unsetBreakpointHook();
        this.unsetDebuggerHook();
        this.unsetErrorHook();
        this.unsetThrowHook();
        this.unsetScriptHook();
        this.unsetInterruptHook();
    }

    public IXPCOMThreadProxyHelper getProxyHelper() {
        return this._proxyHelper;
    }

    protected jsdIDebuggerService getDebuggerService() {
        return this._debuggerService;
    }

    public long enterNestedEventLoop(INestedCallback callback) {
        if (callback != null) {
            callback.onNest();
        }
        return this._eventLoop.runEventLoop();
    }

    public void exitNestedEventLoop(long rv) {
        this._eventLoop.stopEventLoop(rv);
    }

    public IProcess getProcess() {
        return this._process;
    }

    public void setProcess(IProcess process) {
        this.removeWebBrowserListener();
        this._process = process;
        this.addWebBrowserListener();
    }

    private void addWebBrowserListener() {
        nsIWebBrowser browser = (nsIWebBrowser)this._process.getAdapter(nsIWebBrowser.class);
        browser.addWebBrowserListener((nsISupports)this.webProgressListener, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
    }

    private void removeWebBrowserListener() {
        nsIWebBrowser browser;
        if (this._process != null && (browser = (nsIWebBrowser)this._process.getAdapter(nsIWebBrowser.class)) != null) {
            browser.removeWebBrowserListener((nsISupports)this.webProgressListener, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        }
    }

    public IThread[] getThreads() throws DebugException {
        return this._threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length > 0;
    }

    protected void removeThread(IThread thread) {
        ArrayList<JSDebugThread> newThreads = new ArrayList<JSDebugThread>(this._threads.length);
        int i = 0;
        while (i < this._threads.length) {
            newThreads.add(this._threads[i]);
            ++i;
        }
        newThreads.remove(thread);
        this._threads = newThreads.toArray(new JSDebugThread[newThreads.size()]);
    }

    public String getName() throws DebugException {
        return this._appURL == null ? JSDebugCoreMessages.JSDebugCore_0 : this._appURL.toExternalForm();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof JSBreakpoint;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this._terminated;
    }

    public synchronized void terminate() throws DebugException {
        IProcess proc;
        if (this.isTerminated()) {
            return;
        }
        this.shutdown();
        if (this._threads.length > 0) {
            int i = 0;
            while (i < this._threads.length) {
                this._threads[i].terminate();
                ++i;
            }
            this._threads = new JSDebugThread[0];
        }
        if ((proc = this.getProcess()) != null) {
            proc.terminate();
        }
        this._terminated = true;
        this.fireTerminateEvent();
    }

    private void shutdown() {
        this._breakpointManager.removeBreakpointListener((IBreakpointListener)this);
        this._breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this._breakpointManager.removeBreakpointListener((IBreakpointsListener)this._fBreakpointsChangedListener);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.stopDebugger();
    }

    public void resetDebugger() {
        if (this._debuggerService == null) {
            return;
        }
        JSDebugThread thread = this._threads[0];
        thread.clearCX();
        try {
            this._debuggerService.clearAllBreakpoints();
            this._debuggerService.gC();
        }
        catch (XPCOMException e) {
            if (e.errorcode == 2147746065L) {
                MozillaDebugPlugin.log(e);
            }
            throw e;
        }
        if (this.isSuspended()) {
            thread.resumeAbortScript();
        }
    }

    private void stopDebugger() {
        if (this._debuggerService == null) {
            return;
        }
        this.removeDebuggerHooks();
        try {
            this._debuggerService.clearAllBreakpoints();
        }
        catch (XPCOMException e) {
            if (e.errorcode == 2147746065L) {
                MozillaDebugPlugin.log(e);
            }
            throw e;
        }
        if (this.isSuspended()) {
            this.exitNestedEventLoop(1L);
        }
        this._debuggerService.gC();
        if (!this._debuggerService.getInitAtStartup()) {
            this._debuggerService.off();
        }
        this._debuggerService = null;
        this._connected = false;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        boolean atLeastOneThreadCanSuspend = false;
        int i = 0;
        while (i < this._threads.length) {
            atLeastOneThreadCanSuspend |= this._threads[i].canSuspend();
            ++i;
        }
        return !this.isTerminated() && !this.isDisconnected() && !this.isSuspended() && atLeastOneThreadCanSuspend;
    }

    public boolean isSuspended() {
        return this._threads.length > 0 ? this._threads[0].isSuspended() : false;
    }

    public void resume() throws DebugException {
        JSDebugThread thread = this._threads[0];
        thread.resume();
    }

    public void suspend() throws DebugException {
        this._proxyHelper.syncExec(new Runnable(){

            public void run() {
                JSDebugTarget.this._threads[0].setInterruptHook();
            }
        });
    }

    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            final JSSourceLocator locator = (JSSourceLocator)this.getLaunch().getSourceLocator();
            this._debuggerService.enumerateScripts(new jsdIScriptEnumerator(){

                public void enumerateScript(jsdIScript script) {
                    JSDebugTarget.this.establishBreakpoint(true, locator, script, breakpoint);
                }

                public nsISupports queryInterface(String id) {
                    return Mozilla.queryInterface((nsISupports)this, (String)id);
                }
            });
        }
    }

    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            final JSSourceLocator locator = (JSSourceLocator)this.getLaunch().getSourceLocator();
            this._debuggerService.enumerateScripts(new jsdIScriptEnumerator(){

                public void enumerateScript(jsdIScript script) {
                    JSDebugTarget.this.establishBreakpoint(false, locator, script, breakpoint);
                }

                public nsISupports queryInterface(String id) {
                    return Mozilla.queryInterface((nsISupports)this, (String)id);
                }
            });
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this._breakpointManager.isEnabled() && delta != null && this.supportsBreakpoint(breakpoint)) {
            boolean deltaEnabled = delta.getAttribute("org.eclipse.debug.core.enabled", false);
            int deltaLNumber = delta.getAttribute("lineNumber", 0);
            IMarker marker = breakpoint.getMarker();
            int lineNumber = -1;
            lineNumber = marker.getAttribute("lineNumber", 0);
            try {
                if (lineNumber != deltaLNumber) {
                    breakpoint.setMarker(marker);
                }
                if (deltaEnabled != breakpoint.isEnabled()) {
                    if (breakpoint.isEnabled()) {
                        this.breakpointAdded(breakpoint);
                    } else {
                        this.breakpointRemoved(breakpoint, null);
                    }
                }
            }
            catch (CoreException ce) {
                MozillaDebugPlugin.log(ce);
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            if (this.supportsBreakpoint(breakpoints[i])) {
                try {
                    if (breakpoints[i].isEnabled()) {
                        if (enabled) {
                            this.breakpointAdded(breakpoints[i]);
                        } else {
                            this.breakpointRemoved(breakpoints[i], null);
                        }
                    }
                }
                catch (CoreException e) {
                    MozillaDebugPlugin.log(e);
                }
            }
            ++i;
        }
    }

    public boolean establishBreakpoint(boolean activate, JSSourceLocator locator, jsdIScript script, IBreakpoint breakpoint) {
        if (breakpoint instanceof JSDebuggerKeywordBreakpoint) {
            if (activate) {
                this._threads[0].setDebuggerHook();
            } else {
                this.unsetDebuggerHook();
            }
            return true;
        }
        if (breakpoint instanceof JSErrorBreakpoint) {
            this._threads[0].setSuspendOnErrors(activate);
            return true;
        }
        if (breakpoint instanceof JSExceptionBreakpoint) {
            this._threads[0].setSuspendOnExceptions(activate);
            return true;
        }
        if (breakpoint instanceof JSStartupBreakpoint) {
            this._threads[0].setSuspendOnTopLevel(activate);
            return true;
        }
        if (!(breakpoint instanceof JSLineBreakpoint)) {
            return false;
        }
        boolean match = locator.matches(breakpoint, script.getFileName());
        if (match) {
            JSLineBreakpoint jsBPoint = (JSLineBreakpoint)breakpoint;
            try {
                int lineNumber = jsBPoint.getLineNumber();
                match = JSDebugTarget.establishBreakpoint(activate, locator, script, lineNumber);
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.atf.mozilla.ide.debug", 4, JSDebugCoreMessages.JSDebugCore_3, (Throwable)e);
                MozillaDebugPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return match;
    }

    private static boolean establishBreakpoint(boolean activate, JSSourceLocator locator, jsdIScript script, int line) {
        boolean match;
        long baseLineNumber = script.getBaseLineNumber();
        long lineExtent = script.getLineExtent();
        boolean bl = match = (long)line >= baseLineNumber && (long)line <= baseLineNumber + lineExtent && (script.isLineExecutable((long)line, 1L) || baseLineNumber == (long)line);
        if (match) {
            long pc = script.lineToPc((long)line, 1L);
            if (activate) {
                MozillaDebugPlugin.debug("setting breakpoint at " + script.getFileName() + " line=" + line + " pc=" + pc);
                script.setBreakpoint(pc);
            } else {
                MozillaDebugPlugin.debug("clearing breakpoint at " + script.getFileName() + " line=" + line + " pc=" + pc);
                script.clearBreakpoint(pc);
            }
        }
        return match;
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.shutdown();
        if (this._threads.length > 0) {
            int i = 0;
            while (i < this._threads.length) {
                ++i;
            }
            this._threads = new JSDebugThread[0];
        }
        this.fireChangeEvent(512);
    }

    public boolean isDisconnected() {
        return !this._connected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.notSupported("", null);
        return null;
    }

    public ILaunch getLaunch() {
        return this._launch;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getLabel() {
        String urlString = "<unknown>";
        try {
            urlString = this.getName();
        }
        catch (DebugException debugException) {}
        int paramIndex = urlString.indexOf(63);
        StringBuffer label = new StringBuffer(paramIndex > 0 ? urlString.substring(0, paramIndex) : urlString);
        if (this._errorString != null) {
            label.append(" error=");
            label.append(this._errorString);
        }
        label.append(" (");
        if (this.isTerminated()) {
            label.append("Terminated");
        } else if (this.isSuspended()) {
            label.append("Stopped");
        } else if (this.isDisconnected()) {
            label.append(this._debuggerService == null ? "Disconnected" : "Waiting");
        } else {
            label.append("Running");
        }
        label.append(')');
        return label.toString();
    }

    public void handleConnectionStarted() {
        this._connected = true;
        this.fireChangeEvent(256);
        this._threads[0].fireCreationEvent();
    }

    public void handleConnectionTerminated(IStatus status) {
        this._connected = false;
        this.fireChangeEvent(256);
        if (status.getCode() != 0) {
            this._errorString = status.getMessage();
        }
        try {
            this.terminate();
        }
        catch (DebugException de) {
            MozillaDebugPlugin.log(de);
        }
    }

    public void handleLogMessage(IStatus status) {
        if (this._logger != null) {
            this._logger.log(status);
        }
        MozillaDebugPlugin.getDefault().getLog().log(status);
    }

    public void setLogger(ILog logger) {
        this._logger = logger;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 8: {
                    Object source = event.getSource();
                    if (!source.equals(this._process) && !source.equals((Object)this._threads[0])) break;
                    try {
                        this.terminate();
                        break;
                    }
                    catch (DebugException de) {
                        MozillaDebugPlugin.log(de);
                    }
                }
            }
            ++i;
        }
    }

    private void fireError(IStatus status) {
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void unsetDebuggerHook() {
        this._debuggerService.setDebuggerHook(null);
    }

    public void unsetInterruptHook() {
        MozillaDebugPlugin.debug("setInterruptHook(null)");
        this._debuggerService.setInterruptHook(null);
    }

    public void unsetTopLevelHook() {
        this._debuggerService.setTopLevelHook(null);
        MozillaDebugPlugin.debug("setTopLevelHook(null)");
    }

    public void unsetFunctionHook() {
        MozillaDebugPlugin.debug("setFunctionHook(null)");
        this._debuggerService.setFunctionHook(null);
    }

    private void unsetErrorHook() {
        MozillaDebugPlugin.debug("setErrorHook(null)");
        this._debuggerService.setErrorHook(null);
    }

    private void unsetScriptHook() {
        MozillaDebugPlugin.debug("setScriptHook(null)");
        this._debuggerService.setScriptHook(null);
    }

    private void unsetThrowHook() {
        MozillaDebugPlugin.debug("setThrowHook(null)");
        this._debuggerService.setThrowHook(null);
    }

    private void unsetBreakpointHook() {
        MozillaDebugPlugin.debug("setBreakpointHook(null)");
        this._debuggerService.setBreakpointHook(null);
    }

    private class BreakpointsChangedListener
    implements IBreakpointsListener {
        private BreakpointsChangedListener() {
        }

        public void breakpointsAdded(IBreakpoint[] breakpoints) {
        }

        public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
            block5: {
                try {
                    if (!JSDebugTarget.this._breakpointManager.isEnabled()) break block5;
                    int i = 0;
                    while (i < breakpoints.length) {
                        if (JSDebugTarget.this.supportsBreakpoint(breakpoints[i]) && breakpoints[i].isEnabled() && deltas[i] != null) {
                            int deltaLNumber = deltas[i].getAttribute("lineNumber", 0);
                            int lineNumber = -1;
                            IMarker marker = breakpoints[i].getMarker();
                            lineNumber = marker.getAttribute("lineNumber", 0);
                            if (lineNumber != deltaLNumber) {
                                String errorMessage = JSDebugCoreMessages.JSDebugCore_1;
                                Status status = new Status(2, "org.eclipse.atf.mozilla.ide.debug", 120, errorMessage, null);
                                JSDebugTarget.this.fireError((IStatus)status);
                                break;
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException ce) {
                    MozillaDebugPlugin.log(ce);
                }
            }
        }

        public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        }
    }

    public static interface INestedCallback {
        public void onNest();
    }

    class WebProgressListener
    implements nsIWebProgressListener {
        WebProgressListener() {
        }

        public void onLocationChange(nsIWebProgress progress, nsIRequest request, nsIURI location) {
            MozillaDebugPlugin.debug("nsIWebProgressListener.onLocationChange");
            if (location.schemeIs("javascript")) {
                return;
            }
            JSDebugTarget.this.resetDebugger();
        }

        public void onProgressChange(nsIWebProgress progress, nsIRequest request, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
        }

        public void onSecurityChange(nsIWebProgress progress, nsIRequest request, long state) {
        }

        public void onStateChange(nsIWebProgress progress, nsIRequest request, long stateFlags, long status) {
        }

        public void onStatusChange(nsIWebProgress progress, nsIRequest arg1, long status, String message) {
        }

        public nsISupports queryInterface(String string) {
            return Mozilla.queryInterface((nsISupports)this, (String)string);
        }
    }
}

