/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.extras.actions;

import org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMSerializer;
import org.mozilla.interfaces.nsIDOMViewCSS;
import org.mozilla.xpcom.Mozilla;

public class CopyNodeWithStylesAction
extends DOMSelectionAction {
    public static String CLIPBOARD = null;
    private Clipboard clipboard;

    public void run() {
        if (this.getSelection() != null && !this.getSelection().isEmpty()) {
            try {
                try {
                    nsIDOMNode node = this.getSelection().getSelectedNode();
                    nsIDOMNode cloned = node.cloneNode(true);
                    this.setStyles(node, cloned);
                    nsIDOMSerializer domSerializer = (nsIDOMSerializer)Mozilla.getInstance().getComponentManager().createInstanceByContractID("@mozilla.org/xmlextras/xmlserializer;1", null, "{9fd4ba15-e67c-4c98-b52c-7715f62c9196}");
                    this.clipboard = new Clipboard(Display.getCurrent());
                    this.clipboard.setContents(new Object[]{domSerializer.serializeToString(cloned)}, new Transfer[]{TextTransfer.getInstance()});
                }
                catch (Exception exception) {
                    if (this.clipboard != null) {
                        this.clipboard.dispose();
                    }
                }
            }
            finally {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
            }
        }
    }

    private void setStyles(nsIDOMNode node, nsIDOMNode cloned) {
        nsIDOMNodeList list = node.getChildNodes();
        nsIDOMNodeList clonedList = cloned.getChildNodes();
        if (node.getNodeType() == 1) {
            nsIDOMElement domElement = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocumentView documentView = (nsIDOMDocumentView)domElement.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
            nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
            nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(domElement, "");
            String style = domElement.getAttribute("style");
            int j = 0;
            while ((long)j < computedStyle.getLength()) {
                style = String.valueOf(style) + computedStyle.item((long)j) + ":" + computedStyle.getPropertyCSSValue(computedStyle.item((long)j)).getCssText() + ";";
                ++j;
            }
            nsIDOMElement domElement2 = (nsIDOMElement)cloned.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            domElement2.setAttribute("style", style);
        }
        long i = 0L;
        while (i < list.getLength()) {
            nsIDOMNode curr = list.item(i);
            nsIDOMNode curr2 = clonedList.item(i);
            if (curr.getNodeType() == 1) {
                nsIDOMElement domElement = (nsIDOMElement)curr.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                nsIDOMDocumentView documentView = (nsIDOMDocumentView)domElement.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
                nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
                nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(domElement, "");
                String style = domElement.getAttribute("style");
                int j = 0;
                while ((long)j < computedStyle.getLength()) {
                    style = String.valueOf(style) + computedStyle.item((long)j) + ":" + computedStyle.getPropertyCSSValue(computedStyle.item((long)j)).getCssText() + ";";
                    ++j;
                }
                nsIDOMElement domElement2 = (nsIDOMElement)curr2.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                domElement2.setAttribute("style", style);
                this.setStyles(curr, curr2);
            }
            ++i;
        }
    }
}

