/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/

package org.eclipse.atf.resources;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;


public class ResourceChangeListener implements IResourceChangeListener {

	protected ResourceDeltaVisitor deltaVisitor;
	
	public ResourceChangeListener(ResourceDeltaVisitor deltaVisitor) {
		 this.deltaVisitor = deltaVisitor;
	}
	
	public void resourceChanged(IResourceChangeEvent event) {
		
		IResourceDelta delta = event.getDelta();
		int type = event.getType();
		try {
			if (delta != null) {
				deltaVisitor.setChangeType(type);
				delta.accept(deltaVisitor);
			}
		} catch (CoreException ce) {
			CorePlugin.log(ce); 
			ce.printStackTrace();
		}
	}

	

}
